define([
	'Global',
	'Modules',
	'MedFilter',
	'MedFilterView',
	'Text!../../modules/html/templates/navbars/secondaryHeader.html'
	],
	function(Global, Modules, medFilter, medFilterView, secondaryHeader) {
		var SecondaryHeaderView = Backbone.View.extend({
			initialize: function() {
				this.template = _.template(secondaryHeader);
			},
			render: function(details) {
				var template = this.template,
					container = $(this.el),
					actions = details;

				if (details.rightAction) {
					actions.rightAction = $.extend(Modules.getConstants().DEFAULT_RIGHT_ACTION, details.rightAction);
				}
				if (details.leftAction) {
					actions.leftAction = $.extend(Modules.getConstants().DEFAULT_LEFT_ACTION, details.leftAction);
				}

				container.append(template(actions));

				$('#content-secondary').find(":jqmData(role='header')").empty().append(container).trigger('create');

				return container;
			},

			events: {
				"tap #lab-i-btn": "showIButton",
				"tap #Reset-btn": "resetFilters"
			},
			showIButton: function() {
				Global.getUtilities().eventAggregator.trigger('lab-results-information');
			},
			resetFilters : function(){
				medFilter.set(medFilter.defaults);
				medFilterView.setDefaults();
			}

		});
		return SecondaryHeaderView;
	}
);