define([
	'Global',
	'Modules',
	'MhpUser',
	'Patient',
	'secondaryHeaderView',
	'RadiologyTabView',
	'RadiologyByRecent',
	'RadiologyByType',
	'RadiologyListContainerView',
	'RadiologyRecentListView'
	],
	function(Global, Modules, MhpUser, Patient, SecondaryHeaderView, RadiologyTabView, RadiologyRecentCollection, RadiologyGroupedCollection, RadiologyListContainerView, RadiologyRecentListView) {
		var addRadiologyView = function($sectionContainer, $container) {
			var radiologyRecentCollection = new RadiologyRecentCollection();
				radiologyGroupedCollection = new RadiologyGroupedCollection(),
				tabs = {
					leftTab: Modules.getConstants().RAD_RECENT_TAB,
					rightTab: Modules.getConstants().RAD_GROUPED_TAB
				},
				radiologyTabView = new RadiologyTabView(tabs, radiologyRecentCollection, radiologyGroupedCollection),
				radiologyListContainerView = new RadiologyListContainerView(),
				radiologyRecentListView = new RadiologyRecentListView(radiologyRecentCollection);
				$container.append(radiologyTabView.render());
				$container.append(radiologyListContainerView.render());
				$('#lab-list-container', $container).append(radiologyRecentListView.render());
				
				$sectionContainer.empty().append($container).trigger('create');
		};
	
		var RadiologyView = Backbone.View.extend({
			tagName: 'div',
			initialize: function() {
			},
			render: function() {
				var $container = this.$el.empty(),
					$sectionContainer = $('#content-secondary .scrollable').empty(),
					actions = {title: Modules.getConstants().RADIOLOGY_TITLE};

				$('#content-primary .scrollable').empty();
				
				var user = Patient.instance();
				if (user.isValid()) {
					addRadiologyView($sectionContainer, $container);
				} else {
					user.fetch({
						url: MhpUser.instance().get('patient').href,
						async: false,
						success: function(response) {
							Global.getUtilities().flattenLinks(response);
							addRadiologyView($sectionContainer, $container);
						}
					});
				}
				
				var secondaryHeaderView = new SecondaryHeaderView();
				secondaryHeaderView.render(actions);
				
				return $sectionContainer;
			}
		});
		return RadiologyView;
	});