define([
	'Backbone',
	'Modules',
	'Text!../../modules/html/templates/navbars/labTabs.html',
	'RadiologyRecentListView',
	'RadiologyGroupedListView'
	],
	function(Backbone, Modules, tabTemplate, RadiologyRecentListView, RadiologyGroupedListView) {
		var RadiologyTabView = Backbone.View.extend({
			tagName: 'div',
			id: 'tabView',
			attributes: {"data-role": "navbar"},
			initialize: function(tabsObject, radiologyRecentCollection, radiologyGroupedCollection) {
				this.template = _.template(tabTemplate);
				this.tabs = tabsObject || {};
				this.radiologyRecentCollection = radiologyRecentCollection;
				this.radiologyGroupedCollection = radiologyGroupedCollection;
			},
			render: function() {
				var template = this.template,
					$container = $(this.el),
					tabs = this.tabs;
				
				var $ul = $container.empty().append("<ul></ul>").find("ul");

				for (tabKey in tabs) {	// TODO: Update enumeration into for loop!!
					var tabValue = tabs[tabKey];
					$ul.append(template({tab: tabValue}));
				}
				// sets the default tab
				$ul.find('a[title="'+Modules.getConstants().RAD_RECENT_TAB+'"]').attr('class', 'ui-btn-active'); 
				return $container;
			},
			events: {
				"tap a": "filterSecondaryView"
			},
			filterSecondaryView: function(e) {
				e.preventDefault();
				var $target = $(e.currentTarget),
					$listArea = $('#lab-list-container'),
					list,
					radiologyRecentCollection = this.radiologyRecentCollection,
					radiologyGroupedCollection = this.radiologyGroupedCollection;
					
				if ($target.text()===Modules.getConstants().RAD_RECENT_TAB) {
					list = new RadiologyRecentListView(radiologyRecentCollection);
					$listArea.empty().append(list.render());

				} else if ($target.text()===Modules.getConstants().RAD_GROUPED_TAB) {
					list = new RadiologyGroupedListView(radiologyGroupedCollection);
					$listArea.empty().append(list.render());
				}
				$('#content-primary .scrollable').empty();
				$('#content-secondary .scrollable').trigger('create');
			}
		});
		return RadiologyTabView;
	});