define([
	'Global',
	'Modules',
	'RadiologyDetailsView',
	'Text!../../modules/html/templates/lists/collapsibleFolder.html',
	'Text!../../modules/html/templates/lists/radiologyGroupedListItem.html'
	],
	function(Global, Modules, RadiologyDetailsView, groupTemplate, itemTemplate) {
		var RadiologyRecentListView = Backbone.View.extend({
			tagName: 'div',
			id: 'radiology-list',
			initialize: function(radiologyCollection) {
				this.radiologyCollection = radiologyCollection;
				this.groupTemplate = _.template(groupTemplate);
				this.itemTemplate = _.template(itemTemplate);
			},
			render: function() {
				var $container = $(this.el),
					$sectionContainer = $('#content-secondary .scrollable'),
					actions = {title: Modules.getConstants().RADIOLOGY_TITLE},
					radiologyCollection = this.radiologyCollection,
					groupTemplate = this.groupTemplate,
					itemTemplate = this.itemTemplate;
				
				if (radiologyCollection.length===0) {
					$container.append('<ul data-role="listview"></ul>').find('ul').append(itemTemplate({displayName:"No Data Found", noData:true}));
				} else {
					radiologyCollection.each(function(model) {
						var name = model.get('testName'),
							count = model.get('radiologyResults').length;

						$container.append(groupTemplate({folderTitle: name, listTitle: name, counter: count}));

						_.each(model.get('radiologyResults'), function(result) {
							$container.find("ul:last").append(itemTemplate(result));

						});
					});
				}
				
				return $container;
			},
			events: {
				"tap a": "viewReport"
			},
			viewReport: function(e) {
				var itemParent = $(e.currentTarget).parents('li'),
					url = $(e.currentTarget).attr('data-url'),
					view = new RadiologyDetailsView();
					
				if (typeof url !== 'undefined') {
					itemParent.parents('#radiology-list').find('li.ui-btn-active').removeClass('ui-btn-active');
					itemParent.toggleClass('ui-btn-active');

					view.render(url);
					Global.getUtilities().slidePrimary();
				}
			}
		});
		return RadiologyRecentListView;
	});