define([
	'Global',
	'RadiologyDetails',
	'Text!../../modules/html/templates/panes/radiology.html',
	'Text!../../modules/html/templates/panes/notesSection.html'
	],	
	function(Global, RadiologyDetails, radiologyTemplate, blobTemplate) {
		var RadiologyDetailsView = Backbone.View.extend({
			initialize: function() {
			this.radiologyTemplate = _.template(radiologyTemplate)
			this.blobTemplate = _.template(blobTemplate);
			},
            render: function(url) {				
            	var $container = $(this.el),
            		radiologyTemplate = this.radiologyTemplate,
					blobTemplate = this.blobTemplate,
					scope = this;

				var radiologyDetails = new RadiologyDetails();

				radiologyDetails.fetch({
					url: url,
					success: function(model){
						$('#content-primary .scrollable').empty().append(radiologyTemplate(model.toJSON()));
						$('#content-primary .scrollable').append(blobTemplate({
							title: "Radiology Report",
							note: model.toJSON().report
						}));
					}
				});
			}
		});
		 
		return RadiologyDetailsView;
	}
);