define([
	'Global',
	'App',
	'Resources',
	'Patient',
	'Text!../../modules/html/templates/navbars/primaryHeader.html',
	'Text!../../modules/html/templates/navbars/primarySubTitle.html'
	],
	function(Global, App, resources, Patient, primaryHeader, subTitle) {
		var PrimaryHeaderView = Backbone.View.extend({
			initialize: function() {
				this.template = _.template(primaryHeader);
				this.subTitleTemplate = _.template(subTitle);
				this.title = App.defineResourceTitles().title;
				this.patient = Patient.instance();
			},
			render: function(details) {
				var container = $(this.el),
					subTitle = "",
					patient = this.patient;
				
				container.empty().append(this.template($.extend({}, details, {title: this.title})));

				if (patient.isValid() && (App.defineResourceTitles().id === "patient-viewer" || App.defineResourceTitles().id === "schedulingCalendarView")) {
					container.find('h3').append(this.subTitleTemplate($.extend({}, {subTitle: patient.get('lastName'), aside: patient.get('ssn').replace(/.(?=.{4})/g, '')})));
				}

				return container;
			},
			events: {
				'tap #Reference-btn': 'openReferenceSite'
			},
			openReferenceSite: function(e) {
				e.preventDefault();
				var searchTerm = $(document).jqmData('searchTerm');
				var labTestReferenceLink = resources.get('lab-test-reference-link').get('href');
				if(searchTerm !== "" && typeof searchTerm !== 'undefined'){
					searchTerm = '/home/SearchForm?Search=' + searchTerm.replace(/ /g,"+");
					window.open(labTestReferenceLink + searchTerm, '_blank');
				} else {
					window.open(labTestReferenceLink, '_blank');
				}
			}
		});
		return PrimaryHeaderView;
	}
);