define([
	'Global',
	'Modules',
	'Resources',
	'Patients',
	'Patient',
	'secondaryHeaderView',
    'Text!../../modules/html/templates/navbars/patientSearch.html',
	'Text!../../modules/html/templates/lists/listDivider.html',
	'Text!../../modules/html/templates/lists/resultItem.html'
],
	function(Global, Modules, resources, Patients, Patient, SecondaryHeaderView, PatientSearchTemplate, listDividerTemplate, resultItemTemplate){
		var PatientSearchView = Backbone.View.extend({
				tagName: 'div',
				id: 'patient-search',
				dataLoading: false,
				endOfMessages: false,
				attributes: {},
				initialize: function(){
                    this.template = _.template(PatientSearchTemplate);
					this.listDividerTemplate = _.template(listDividerTemplate);
					this.resultItemTemplate = _.template(resultItemTemplate);
				},
				render: function(){
					var that = this,
						container = $(this.el),
						template = this.template,
						actions = {title: Modules.getConstants().PATIENT_SEARCH_TITLE},
						sectionContainer = $('#content-secondary .scrollable'),
						secondaryHeaderView = new SecondaryHeaderView();

					container.empty();
					sectionContainer.off().empty();

					container.append(template());

					$(":jqmData(role='header')", sectionContainer).append(secondaryHeaderView.render(actions));
					sectionContainer.append(container).trigger('create');

					if (Patient.instance().isValid()) {
						this.addPatient(Patient.instance());
					}

					var scrollDirection,
						tempScrollTop,
						currentScrollTop = 0;
					$('#content-secondary .scrollable').scroll(function(){
						if (!$('> ul', this).hasClass('no-scroll-event')) {
							currentScrollTop = $(this).scrollTop();

							if (tempScrollTop < currentScrollTop )
								scrollDirection = "down";
							else if (tempScrollTop > currentScrollTop )
								scrollDirection = "up";

							tempScrollTop = currentScrollTop;

							if (!that.endOfMessages && scrollDirection === "down") {
								var triggerPoint = 100; // 100px from the bottom

								if (!that.dataLoading && triggerPoint + this.clientHeight + this.scrollTop > this.scrollHeight) {
									that.dataLoading = true;
									that.next();
								}
							}
						}
					});
				},
				events: {
					"tap .section-list-item": "viewPatientSummary",
					"keypress input[name=patient-search]": "search"
				},
				addPatient: function(patient){
					var $ul = $('#patient-search-results').empty();

					var htmlArray = [];
					htmlArray.push(this.listDividerTemplate({ numberOfDisplayedResults: 1, totalResults: 1}));
					htmlArray.push(this.resultItemTemplate(patient.toJSON()));

					$ul.append(htmlArray.join(''));

					if ($ul.hasClass('ui-listview')) {
						$ul.listview('refresh');
					}
					else {
						$ul.trigger('create');
					}

					$('li .section-list-item', $ul).trigger('tap');

					this.endOfMessages = true;
				},
				search: function(e){
					if (e.which === 13 || e.keyCode === 13) {
						var that = this,
							$ul = $('#patient-search-results').empty();

						this.searchedUrl = resources.get('patients').get('href') + "?searchstring=" + $('input[name=patient-search]').val();

						Patients.instance().fetch({
							url: this.searchedUrl,
							success: function(collection) {
								var htmlArray = [];
								htmlArray.push(that.listDividerTemplate(collection));
								$(collection.models).each(function() {
									htmlArray.push(that.resultItemTemplate(this.toJSON()));
								});
								$ul.append(htmlArray.join(''));
								$ul.listview('refresh');

								if (!collection.nextPage) {
									that.endOfMessages = true;
								} else {
									that.endOfMessages = false;
								}
							},
							error: function() {
								that.endOfMessages = true;
							}
						});
					}
				},
				next: function(e){
					if (typeof this.searchedUrl !== 'undefined' && this.searchedUrl && typeof Patients.instance().nextPage !== 'undefined' && Patients.instance().nextPage) {
						var that = this,
							$ul = $('#patient-search-results');

						Patients.instance().fetch({
							url: this.searchedUrl + '&page=' + Patients.instance().nextPage,
							success: function(collection) {
								$('#displayed-result-count').html('Displaying ' + Patients.instance().numberOfDisplayedResults+ ' results');

								$(collection.models).each(function() {
									$ul.append(that.resultItemTemplate(this.toJSON()));
								});

								$ul.listview('refresh');

								if (!collection.nextPage) {
									that.endOfMessages = true;
								}

								that.dataLoading = false;
							},
							error: function() {
								that.dataLoading = false;
							}
						});
					}
				},
				viewPatientSummary: function(e) {
					e.preventDefault();
					var $currentTarget = $(e.currentTarget),
						selflink = $currentTarget.data('selflink'),
						itemParent = $currentTarget.parents('li'),
						patientDetailsSelected = this.options.patientDetailsSelected;

					itemParent.parents('#patient-search-results').find('li.ui-btn-active').removeClass('ui-btn-active');

					if (typeof selflink !== 'undefined' && selflink) {
						Patient.instance().fetch({
							url: selflink,
							success: function(response) {
								itemParent.toggleClass('ui-btn-active');
								$('#footer').find('li[data-requires-patient=true]').each(function(i) {
									$(this).removeClass('ui-disabled');
								});

								$('#footer-menu-popup').find('li[data-requires-patient=true]').each(function(i) {
									$(this).removeClass('ui-disabled');
								});

								Global.getUtilities().flattenLinks(response);
								Global.getUtilities().eventAggregator.trigger('footer');
								Global.getUtilities().slidePrimary();

                                patientDetailsSelected();
							}
						});
					}
				}
			});

		return PatientSearchView;
	}
);