define([
	'Global',
	'App',
	'Patient',
	'primaryHeaderView',
	'Allergies',
	'ContactInformation',
	'MedicalDiagnoses',
	'Medications',
	'Surgeries',
	'Text!../../modules/html/templates/panes/layout.html',
	'Text!../../modules/html/templates/panes/contactInformation.html',
	'Text!../../modules/html/templates/panes/allergies.html',
	'Text!../../modules/html/templates/panes/medicalDiagnoses.html',
	'Text!../../modules/html/templates/panes/medications.html',
	'Text!../../modules/html/templates/panes/surgeries.html'
	],
	function(Global, App, Patient, PrimaryHeaderView, Allergies, ContactInformation, MedicalDiagnoses, Medications, Surgeries,
			layoutTemplate, contactInformationTemplate, allergiesTemplate, medicalDiagnosesTemplate, medicationsTemplate, surgeriesTemplate) {
		var PatientDetailsView = Backbone.View.extend({
			el: '#content-primary .scrollable',
			initialize: function() {
				this.template = _.template(layoutTemplate);
				this.contactInformationTemplate = _.template(contactInformationTemplate);
				this.allergiesTemplate = _.template(allergiesTemplate);
				this.medicalDiagnosesTemplate = _.template(medicalDiagnosesTemplate);
				this.medicationsTemplate = _.template(medicationsTemplate);
				this.surgeriesTemplate = _.template(surgeriesTemplate);
			},
			render: function() {
				var that = this,
					details = 
					primaryHeaderView = new PrimaryHeaderView();

				this.$el.empty().append(this.template());
				$('#content-primary').find(":jqmData(role='header')").empty().append(primaryHeaderView.render()).trigger('create');

				var $contactInformation = $('#contactInformation'),
					$allergies = $('#allergies'),
					$medicalDiagnoses = $('#medicalDiagnoses'),
					$inpatientMeds = $('#inpatientMeds'),
					$outpatientMeds = $('#outpatientMeds'),
					$surgeries = $('#surgeries');

				new ContactInformation().fetch({
					success: function(model) {
						$contactInformation.empty().append(that.contactInformationTemplate($.extend(Patient.instance().toJSON(), model.toJSON())));
					}
				});
				new Allergies().fetch({
					success: function(model) {
						$allergies.empty().append(that.allergiesTemplate(model.toJSON()));
					}
				});
				new MedicalDiagnoses().fetch({
					success: function(model) {
						$medicalDiagnoses.empty().append(that.medicalDiagnosesTemplate(model.toJSON()));
					}
				});
				new Medications().fetch({
					success: function(model) {
						if (App.defineResourceTitles().id === 'patient-viewer') {
							$inpatientMeds.empty().append(that.medicationsTemplate($.extend(model.toJSON(), {source: 'INPATIENT'})));
						}
						$outpatientMeds.empty().append(that.medicationsTemplate($.extend(model.toJSON(), {source: 'OUTPATIENT'})));
					}
				});
				new Surgeries().fetch({
					success: function(model) {
						$surgeries.empty().append(that.surgeriesTemplate(model.toJSON()));
					}
				});
			}
		});
		return PatientDetailsView;
	}
);