define([
	'Global',
    'PastEvent',
	'Text!../../modules/html/templates/panes/pastEventDetails.html',
	'Text!../../modules/html/templates/panes/notesSection.html'
	],
	function(Global, pastEvent, pastEventTemplate, notesSectionTemplate) {
		var PastEventDetail = Backbone.View.extend({
			tagName: 'div',
			id: 'clinic-event-details',
			model: pastEvent,
			attributes: {"class": "content-primary ui-btn-up-b", "data-tap-toggle": "false"},
			initialize: function() {
				this.template = _.template(pastEventTemplate);
				this.notesTemplate = _.template(notesSectionTemplate);
			},
			render: function(uri) {
				var template = this.template,
					notesTemplate = this.notesTemplate,
					container = $('#content-primary .scrollable');

				var newEvent = new pastEvent();

				container.empty();

				newEvent.fetch({
					async: false,
					url: uri
				});
				container.append(template(newEvent.toJSON()));
				container.append(notesTemplate(newEvent.toJSON()));
			}
		});
		
		return PastEventDetail;
	}
);