define([
	'secondaryHeaderView',
	'MedFilterView',
	'MedListView',
	'Modules'
	],
	function(SecondaryHeaderView, medFilterView, MedListView, Modules) {
		var MedView = Backbone.View.extend({
			render: function(initialLoad) {
				var actions = {title: Modules.getConstants().MEDICATIONS_TITLE, rightAction: {id: 'Reset', name: 'Reset', icon: 'refresh', theme: 'd'}},
					secondaryHeaderView = new SecondaryHeaderView(),
					medListView = new MedListView(),
					viewToBeTriggered = medListView.render();

				secondaryHeaderView.render(actions);

				medFilterView.render(initialLoad);

				return viewToBeTriggered;
			}
		});
		return MedView;
	});