define([
	'Global',
	'App',
	'Modules',
	'MhpUser',
	'Patient',
	'Meds',
	'MedFilter',
	'MedDetailsView',
	'Text!../../modules/html/templates/lists/medListItem.html'
],
	function(Global, App, Modules, MhpUser, Patient, Meds, medFilter, medDetailsView, medListItem ){
		var MedListView = Backbone.View.extend({
			tagName: 'ul',
			attributes: {'data-role': 'listview', 'data-theme': 'c'},
			id: 'medications-list',
			initialize: function(){
				this.stopListening(medFilter);
				this.listenTo(medFilter, 'change', this.render);
				this.template = _.template(medListItem);
			},
			render: function() {
				var $container = this.$el.empty(),
					$sectionContainer = $('#content-primary').find('.scrollable').empty(),
					that = this;

				var user = Patient.instance();
				if (user.isValid()) {
					this.addMedListView($sectionContainer, $container);
				} else {
					user.fetch({
						url: MhpUser.instance().get('patient').href,
						success: function(response) {
							Global.getUtilities().flattenLinks(response);
							that.addMedListView($sectionContainer, $container);
						}
					});
				}
				this.delegateEvents();
				return $sectionContainer;
			},
			addMedListView : function($sectionContainer, $container) {
				var collection = this.collection = new Meds(),
					template = this.template;

				$.mobile.loading('show');
				collection.fetch({success: function(response) {
					if (collection.models.length===0) {
						$container.append(template({displayName:"No Data Found Within the Specified Selection", noData:true}));
					} else {
						collection.each(function(model) {
							Global.getUtilities().flattenLinks(model);
							if (typeof App.defineResourceTitles().medicationsDetailsTitle !== 'undefined') {
								var url = model.get(App.defineResourceTitles().medicationsDetailsTitle).href;
							}
							$container.append(template($.extend(model.toJSON(), {url: url})));
						});
					}

					$sectionContainer.append($container).trigger('create');
				}});
				
			},
			events: {
				"tap li": "openDetails"
			},
			openDetails : function(e) {
				e.preventDefault();
				if (App.defineResourceTitles().medicationsDetailsTitle) {
					var $targetURL = $(e.currentTarget).find('a').attr('id');
					medDetailsView.render($targetURL);
				}
			}
		});
		return MedListView;
	}
);