define([
	'Backbone',
	'Modules',
	'App',
	'secondaryHeaderView',
	'MedFilter',
	'Text!../../modules/html/templates/panes/medFilter.html',
	'Text!../../modules/html/templates/menus/rangeMenu.html'
	],
	function(Backbone, Modules, App, SecondaryHeaderView, medFilter, filterTemplate, rangeFilter) {
		var MedFilterView = Backbone.View.extend({
			tagName: 'div',
			initialize: function() {
				this.filterTemplate = _.template(filterTemplate);
				this.rangeFilterTemplate = _.template(rangeFilter);
				this.medFilter = medFilter;
				this.listenTo(this.medFilter, 'change', this.changeRangeDisplay);
			},
			render: function() {
				var $container = $(this.el).empty(),
					$sectionContainer = $('#content-secondary .scrollable'),
					filterTemplate = this.filterTemplate,
					rangeFilterTemplate = this.rangeFilterTemplate;
				$container.append(filterTemplate({appId: App.defineResourceTitles().id}));
				$container.append(rangeFilterTemplate(this.medFilter.toJSON()));

				$sectionContainer.empty().append($container);
				$sectionContainer.trigger('create');

				this.changeRangeDisplay();
				this.delegateEvents();
				this.setDefaults();
			},
			events: {
				"tap #filter-range-btn"	: "filterByRange",
				"change select"			: "updateModel"
			},
			updateModel: function(e) {
				e.preventDefault();
				var $target = $(e.currentTarget);
				if ($target.val() === null){
					$target.val(this.medFilter.get($target.attr('name')));
					$target.selectmenu('refresh');
				} else {
					$formParams = $('#content-secondary').find('form').formParams();
					this.medFilter.set($formParams);
				}
			},
			changeRangeDisplay: function() {
				var $rangeFilterBtn = $('#filter-range-btn');
				console.log(this.medFilter);
				$rangeFilterBtn.text(this.medFilter.get('startDate') + ' - ' + this.medFilter.get('endDate'));
				$rangeFilterBtn.siblings().find('.ui-btn-text').text(this.medFilter.get('startDate') + ' - ' + medFilter.get('endDate'));
			},
			setDefaults: function() {
				var $formSelects = $('#content-secondary .scrollable').find('select');
				$formSelects.each(function(select){
					var $this = $(this),
						$defaultValue = medFilter.get($this.attr('name')),
						size = $defaultValue.length,
						currentValue;
					$this.find('option:selected').prop("selected", false);

					if (typeof $defaultValue === "object") {
						for (var i=0; i<size; i++) {
							$this.find('option[value="'+$defaultValue[i]+'"]').attr("selected","selected");
						}
					} else {
						$this.find('option[value="'+$defaultValue+'"]').attr("selected","selected");
					}
				});
				$formSelects.selectmenu('refresh');
			},
			filterByRange: function(e) {
				e.preventDefault();
				var rangeMenu = $('#range-menu');

				rangeMenu.popup('open');
				rangeMenu.trigger('create');

				var restrictDate = function() {
					var endDay = new Date($('#filter-date-to').val()),
						today = new Date(),
						diff = parseInt((endDay - today) / 24 / 60 / 60 / 1000, 10);
					$('#filter-date-from').data('datebox').options.maxDays = diff;
					$('#filter-date-from').data('datebox').options.minDays = (diff*-1) + 2190; //6 years
				};

				restrictDate();

				$('#range-menu-popup').on('change','#filter-date-to, #filter-date-from', function() {
					var dateFrom = $('#filter-date-from');

					if (new Date(this.value) < new Date(dateFrom.val())){
						dateFrom.val('');
					}
					if (this.value.length > 0 && dateFrom.val().length > 0) {
						$('#range-apply-btn').removeClass('ui-disabled');
					} else {
						$('#range-apply-btn').addClass('ui-disabled');
					}
					restrictDate();
				});

				$(rangeMenu).bind({
					popupafterclose: function() {
						var title = $('.ui-datebox-container').find('.ui-header h1').text().toLowerCase();

						$('#filter-date-' + title).datebox('close');
						$('#main .apply-btn').unbind();
					}
				});
				$('#main .apply-btn').bind('tap', function(e){
					e.preventDefault();

					var formParams = $(this).parents('form').formParams();
					medFilter.set(formParams);

					rangeMenu.popup('close');
				});
			}
		});
		return new MedFilterView();
	});