define([
	'Global',
	'App',
	'Meds',
	'MedDetails',
	'Text!../../modules/html/templates/panes/medDetails.html'
	],
	function(Global, App, Meds, MedDetails, medTemplate) {
		var MedDetailsView = Backbone.View.extend({
			initialize: function() {
				this.medTemplate = _.template(medTemplate);
			},
            render: function(url) {
				var $container = $(this.el),
					medTemplate = this.medTemplate,
					that = this,
					medDetails = new MedDetails();

				medDetails.fetch({
					url: url,
					success: function(model){
						var $sectionContainer = $('#content-primary');
						$container.empty().append(that.medTemplate(model.toJSON()));
						$sectionContainer.append($container);
						that.activatePopup();
					}
				});
			},
			activatePopup: function() {
				$medsPopup = $('#meds-details-popup');
				$medsPopup.popup().popup('open').trigger('create');
				$medsPopup.find('.scrollable').css({
					'max-height': $(window).height()-60
				});

				$medsPopup.bind({
					afterclose: function() {
						$medsPopup.parent('.ui-popup-container').remove();
					}
				});
			}
		});

		return new MedDetailsView();
	}
);