define([
	'Global',
	'MhpUser',
	'Patient',
	'Modules',
	'App',
	'secondaryHeaderView',
	'LabResultsTabView'
	],
	function(Global, MhpUser, Patient, Modules, App, SecondaryHeaderView, LabResultsTabView) {
		var LabResultsView = Backbone.View.extend({
			tagName: 'div',
			initialize: function() {
				this.location = window.location.hash;
			},
			render: function() {
				var actions = {title: Modules.getConstants().LAB_RESULTS_TITLE},
					scope = this;

				var secondaryHeaderView = new SecondaryHeaderView(),
					$sectionContainer = $('#content-secondary .scrollable');
					details = {rightAction: 'Reference'},
					user = Patient.instance();

				$(document).jqmData('searchTerm', ""); //for reference button
				$('#content-primary .scrollable').empty();

				if (App.defineResourceTitles().id === 'summaryofcare') {
					actions.rightAction = {id: 'lab-i', name: 'Information about Lab Results', icon: 'info', theme: 'b', noText: true};
				}
				secondaryHeaderView.render(actions);

				if (user.isValid()) {
					new LabResultsTabView().render();
				} else {
					user.fetch({
						url: MhpUser.instance().get('patient').href,
						success: function(response) {
							Global.getUtilities().flattenLinks(response);
							new LabResultsTabView().render();
						}
					});
				}

				return $sectionContainer;
			},
		});
		return LabResultsView;
	});