define([
	'Global',
	'MicrobiologyDetailedReport',
	'Text!../../modules/html/templates/panes/notesSection.html'
	],	
	function(Global, MicrobiologyDetailedReport, microbiologyTemplate) {
		var LabResultsDetailsView = Backbone.View.extend({
			initialize: function() {
			this.template = _.template(microbiologyTemplate);
			},
            render: function(url) {				
            	var $container = $(this.el),
					template = this.template,
					scope = this;

				var microbiologyDetailedReport = new MicrobiologyDetailedReport();

				microbiologyDetailedReport.fetch({
					url: url,
					success: function(model){
						$('#content-primary .scrollable').empty().append(template({
							title: "Microbiology Detailed Report",
							note: model.toJSON().value
						}));
					}
				});
			}
		});
		 
		return LabResultsDetailsView;
	}
);