define([
	'Global',
	'Utilities',
	'Modules',
	'Patient',
	'Durations',
	'Duration',
	'Text!../../modules/html/templates/lists/listItem.html',
	'Text!../../modules/html/templates/lists/durationListItem.html',
	'Text!../../modules/html/templates/menus/customDateMenu.html',
	'LabResultsTimeDetailsView'
],
	function(Global, Utilities, Modules, Patient, durations, Duration, listItemTemplate, durationListItemTemplate, customDateMenu, LabResultsTimeDetailsView) {
		var LabResultsMicroListView = Backbone.View.extend({
			tagName: 'div',
			id: 'lab-list',
			className: 'tab-content-container',
			initialize: function() {
				this.listItemTemplate = _.template(listItemTemplate);
				this.durationListItemTemplate = _.template(durationListItemTemplate);
				this.customDateMenu = _.template(customDateMenu);
			},
			render: function() {
				var $container = this.$el,
					customDateMenu = this.customDateMenu;

				var $ul = $container.append(customDateMenu({endDate: produceDate(0)})).append('<ul data-role="listview"></ul>').find('ul');

				this.resetCustomDateMenu();
				this.drawDuration(durations, true);

				return $container;
			},
			resetCustomDateMenu: function() {
				$('#date-from').val('');
				$('#date-to').val(formatDate(new Date()));
			},
			drawDuration: function(durations, initialLoad) {
				var $ul = this.$el.find('ul'),
					that = this;
				$ul.empty();
				durations.each(function(duration) {
					$ul.append(that.durationListItemTemplate(duration.toJSON()));
				});
				$ul.append(this.listItemTemplate({target:"", title: "Add Custom Range"}));

				if (initialLoad) {
					$ul.trigger('create');
				} else {
					$ul.listview('refresh');
				}
			},
			events: {
				"tap a": "viewReport",
				"tap a[title='Add Custom Range']": "addCustomRange"
			},
			viewReport: function(e) {
				var startDate = $(e.currentTarget).data('start-date'),
					endDate = $(e.currentTarget).data('end-date');
				
				if (typeof startDate !== 'undefined' && typeof endDate !== 'undefined') {
					var url = Patient.instance().get('patient-lab-results-longitudinal').href + '?startDate=' + startDate + '&endDate=' + endDate,
						itemParent = $(e.currentTarget).parents('li'),
						view = new LabResultsTimeDetailsView();
					
					// show item as selected
					itemParent.parents('#lab-list').find('li.ui-btn-active').removeClass('ui-btn-active');
					itemParent.toggleClass('ui-btn-active');

					view.render(url);
					
					Global.getUtilities().slidePrimary();
				}
			},
			addCustomRange: function(e) {
				var that = this,
					dateMenu = $('#custom-date-menu');
				
				dateMenu.popup('open');
				dateMenu.trigger('create');
				
				var restrictDate = function() {
					var endDay = new Date($('#date-to').val()),
						today = new Date(),
						diff = parseInt((endDay - today) / 24 / 60 / 60 / 1000);
					$('#date-from').data('datebox').options.maxDays = diff;
					$('#date-from').data('datebox').options.minDays = (diff*-1) + 2190; //6 years
				};

				restrictDate();
				$('#custom-date-menu-popup').on('change','#date-to, #date-from', function() {
					var dateFrom = $('#date-from');
					
					if (new Date(this.value) < new Date(dateFrom.val())){
						dateFrom.val('');
					}
					if (this.value.length > 0 && dateFrom.val().length > 0) {
						$('#add-custom-date').removeClass('ui-disabled');
					} else {
						$('#add-custom-date').addClass('ui-disabled');
					}
					restrictDate();
				});

				$(dateMenu).bind({
					popupafterclose: function() {
						var title = $('.ui-datebox-container').find('.ui-header h1').text().toLowerCase();
						$('#date-' + title).datebox('close');
						$('#add-custom-date').unbind();
					}
				});
				$('#add-custom-date').bind('tap', function(e){
					e.preventDefault();
					$(document).jqmData('searchTerm', undefined);
					var duration = new Duration($(this).parents('form').formParams());
					duration.set({
						'title': duration.get('startDate') + '  -  ' + duration.get('endDate')
					});
					durations.add(duration);
					that.drawDuration(durations);
					dateMenu.popup('close');
				});
			}
		});
		return LabResultsMicroListView;
	});
