define([
	'Global',
	'TimeDetailedReport',
	'Text!../../modules/html/templates/lists/detailsListItem.html',
	'Text!../../modules/html/templates/lists/labResultsList.html',
	'Text!../../modules/html/templates/lists/labResultsListItem.html',
	'Text!../../html/templates/common/errorMessage.html'
	],	
	function(Global, TimeDetailedReport, listItemTemplate, labResultsListTemplate, labResultsListItemTemplate, errorMessageTemplate) {
		var LabResultsDetailsView = Backbone.View.extend({
			initialize: function() {
				this.listItemtemplate = _.template(listItemTemplate);
				this.template = _.template(labResultsListTemplate);
				this.labResultsItemTemplate = _.template(labResultsListItemTemplate);
				this.errorMessageTemplate = _.template(errorMessageTemplate);
			},
            render: function(url) {				
            	var $container = $container = $('#content-primary .scrollable').empty(),
					template = this.template,
					labResultsItemTemplate = this.labResultsItemTemplate,
					listItemtemplate = this.listItemtemplate,
					errorMessageTemplate = this.errorMessageTemplate;
					scope = this;

				var timeDetailedReport = new TimeDetailedReport();

	            timeDetailedReport.fetch({
					url: url,
					success: function(model){
						var labResults = model.get('labResult');
						
						$container.append(template());
						if (labResults) {
							var $list = $container.find('ul');
							
							$list.append(listItemtemplate({title:"Lab Results", text: "Number of Lab Results in this date range: <b>" + labResults.length + "</b>"}));
							
							$(labResults).each(function(i) {
								$list.append(labResultsItemTemplate(this));
							});
						} else {
							$container.append(errorMessageTemplate({error: "No Data Found Within the Specified Date Range"}));
						}
			            $container.trigger('create');
					}
				});
			}
		});
		 
		return LabResultsDetailsView;
	}
);