define([
	'Backbone',
	'App',
	'primaryHeaderView',
	'LabResultsGraphListView',
	'LabResultsTimeListView',
	'LabResultsMicroListView',
	'Text!../../modules/html/templates/navbars/labTabs.html'
	],
	function(Backbone, App, PrimaryHeaderView, LabResultsGraphListView, LabResultsTimeListView, LabResultsMicroListView, tabTemplate) {
		var TabView = Backbone.View.extend({
			tagName: 'div',
			id: 'tabView',
			attributes: {"data-role": "navbar"},
			initialize: function() {
				this.template = _.template(tabTemplate);
				this.tabs = App.getConstants().tabs || {};
				this.$sectionContainer = $('#content-secondary').find('.scrollable').empty();
			},
			render: function() {
				var template = this.template,
					$sectionContainer = this.$sectionContainer,
					$container = $(this.el).empty().append("<ul></ul>"),
					$ul = $container.find("ul"),
					tabs = this.tabs,
					primaryHeaderView = new PrimaryHeaderView();

				for (var tabKey in tabs) {
					var tabValue = tabs[tabKey];
					$ul.append(template({tab: tabValue}));
				}

				$ul.find('a[title="'+tabs.LAB_RESULTS_GRAPH_TAB+'"]').attr('class', 'ui-btn-active');
				$sectionContainer.append($container).trigger('create');
				this.renderList(this.pickGraphList(primaryHeaderView));
			},
			events: {
				"tap a": "tabSelection"
			},
			tabSelection: function(e) {
				e.preventDefault();
				var $targetText = $(e.currentTarget).text(),
					list,
					tabs = this.tabs,
					primaryHeaderView = new PrimaryHeaderView();

				if ($targetText === tabs.LAB_RESULTS_GRAPH_TAB) {
					this.renderList(this.pickGraphList(primaryHeaderView));
				} else if ($targetText === tabs.LAB_RESULTS_MICRO_TAB) {
					this.renderList(this.pickMicroList(primaryHeaderView));
				} else if ($targetText === tabs.LAB_RESULTS_TIME_TAB) {
					this.renderList(this.pickTimeList(primaryHeaderView));
				}

				$('#content-primary').find('.scrollable').empty();
			},
			renderList: function(list) {
				var	$sectionContainer = this.$sectionContainer,
					$sectionListContainer = $sectionContainer.find('.tab-content-container');
				$sectionListContainer.remove();
				$sectionContainer.append(list.render());
				$sectionContainer.trigger('create');
			},
			pickGraphList: function(primaryHeaderView) {
				$(document).jqmRemoveData('searchTerm');
				var list = new LabResultsGraphListView();
				$('#content-primary').find(":jqmData(role='header')").empty().append(primaryHeaderView.render({rightAction: 'Reference'})).trigger('create');
				return list;
			},
			pickTimeList: function(primaryHeaderView) {
				var list = new LabResultsTimeListView();
				$('#content-primary').find(":jqmData(role='header')").empty().append(primaryHeaderView.render()).trigger('create');
				return list;
			},
			pickMicroList: function(primaryHeaderView) {
				var list = new LabResultsMicroListView();
				$('#content-primary').find(":jqmData(role='header')").empty().append(primaryHeaderView.render()).trigger('create');
				return list;
			}
		});
		return TabView;
	});