define([
	'Global',
	'LabResultsMicroDetailsView',
	'MicrobiologyReportsByGroup',
	'Text!../../modules/html/templates/lists/collapsibleFolder.html',
	'Text!../../modules/html/templates/lists/microbiologyListItem.html'
	],
	function(Global, LabResultsMicroDetailsView, MicrobiologyReportsByGroup, collapsibleHeaderTemplate, microbiologyTemplate) {
		var microbiologyReportsByGroup = null,
			LabResultsMicroListView = Backbone.View.extend({
			tagName: 'div',
			id: 'lab-list',
			className: 'tab-content-container',
			initialize: function() {
				this.collapsibleHeaderTemplate = _.template(collapsibleHeaderTemplate);
				this.microbiologyTemplate = _.template(microbiologyTemplate);
			},
			render: function() {
				var $container = $(this.el),
					itemTemplate = this.microbiologyTemplate,
					groupTemplate = this.collapsibleHeaderTemplate,					
					that = this;
				
				microbiologyReportsByGroup = new MicrobiologyReportsByGroup();
				
				$.mobile.loading('show');
				microbiologyReportsByGroup.fetch({success: function(collection) {
					if (collection.length===0){
						$container.append('<ul data-role="listview"></ul>').find('ul').append(itemTemplate({displayName:"No Data Found", noData:true}));
					} else {
						var microbiologyGroup = {};

						collection.each(function(model) {
							var groupName = model.get('name');

							microbiologyGroup[groupName] = [];

							var labTests = model.get('labTest');

							$(labTests).each(function() {
								var labTest = this;
								$(labTest.labResult).each(function() {
									var $labResults = $(this);

									$labResults.each(function() {
										microbiologyGroup[groupName].push(this);
									});
								});
							});

							// TODO: sort microbiologyGroup[groupName]!!!
							//
							var groupHtml = $(groupTemplate({folderTitle: groupName, listTitle: groupName, counter: microbiologyGroup[groupName].length}));

							$(microbiologyGroup[groupName]).each(function() {
								$("ul", groupHtml).append(itemTemplate(this));
							});

							$container.append(groupHtml);
						});
					}
					$container.trigger('create');
				}});
				
				return $container;
			},
			events: {
				"tap a": "viewReport"
			},
			viewReport: function(e) {
				var itemParent = $(e.currentTarget).parents('li'),
					id = $(e.currentTarget).attr('data-lab-id'),
					view = new LabResultsMicroDetailsView();

				if(typeof id !== 'undefined' && microbiologyReportsByGroup){
					$('#lab-list').find('li').removeClass('ui-btn-active');
					itemParent.toggleClass('ui-btn-active');
					
					var labResult = null;
					if (typeof microbiologyReportsByGroup.models !== 'undefined' && microbiologyReportsByGroup.models) {
						$(microbiologyReportsByGroup.models).each(function(){
							var labTests = this.get('labTest');
							
							if (typeof labTests !== 'undefined' && labTests) {
								$(labTests).each(function() {
									var labResults = this.labResult;
									if (typeof labResults !== 'undefined' && labResults) {
										$(labResults).each(function() {
											if (this.dataIdentifier && this.dataIdentifier.uniqueId === id) {
												labResult = this;
											}
										});
									}
								});
							}
						});
					}
					
					if (typeof labResult !== 'undefined' && labResult) {
						itemParent.parents('#lab-list').find('li.ui-btn-active').removeClass('ui-btn-active');
						itemParent.toggleClass('ui-btn-active');

						view.render(labResult);
						Global.getUtilities().slidePrimary();
					}
				}
			}
		});
		return LabResultsMicroListView;
	});