define([
	'Backbone',
	'Global',
	'Text!../../modules/html/templates/panes/labResultsInfo.html'
	],
	function(Backbone, Global, labResultsInfoTemplate) {
		var labResultsInfoView = Backbone.View.extend({
			id: 'lab-results-info',
			tagName: 'div',
			attributes: {'data-role': 'dialog'},
			className: 'listview-dialog',
			initialize: function() {
				this.template = _.template(labResultsInfoTemplate);
			},
			render: function() {
				var container = $(this.el),
					template = this.template;
				container.empty().append(template);
				container.trigger('create');
				$('body').append(container);
			},
			events: {
				"tap #lab-i-ok-btn": "dismiss",
				"tap a[title='Close']": "dismiss"
			},
			dismiss: function(e) {
				e.preventDefault();
				Global.getUtilities().eventAggregator.trigger('lab-results');
			}
		});
		return labResultsInfoView;
	});