define([
	'Global',
	'Modules',
	'GraphView',
	'LabGraphData',
	'GraphLabResultsByGroup',
	'primaryHeaderView',
	'Text!../../modules/html/templates/lists/collapsibleFolder.html',
	'Text!../../modules/html/templates/lists/labResultsGraphListItem.html'
],
	function(Global, Modules, GraphView, LabGraph, GraphLabResultsByGroup, PrimaryHeaderView, collapsibleHeaderTemplate, chemHemTemplate){
		var LabResultsListView = Backbone.View.extend({
			tagName: 'div',
			id: 'lab-list',
			className: 'tab-content-container',
			initialize: function(){
				this.chemHemTemplate = _.template(chemHemTemplate);
				this.collapsibleHeaderTemplate = _.template(collapsibleHeaderTemplate);
				this.LabGraph = LabGraph;
			},
			render: function(){
				var $container = $(this.el),
					itemTemplate = this.chemHemTemplate,
					groupTemplate = this.collapsibleHeaderTemplate,
					primaryHeaderView = new PrimaryHeaderView(),
					details = {rightAction: 'Reference'},
					validLabResultsExist = false,
					that = this,
					chemLabResultsByGroup = new GraphLabResultsByGroup();

				$.mobile.loading('show');
				chemLabResultsByGroup.fetch({
					success: function(collection) {
					if(collection.length > 0){
						collection.each(function(model){
							var name = model.get('name'),
								labTest = model.get('labTest'),
								count = 0;
							if (typeof labTest !== 'undefined' && labTest){
								count = labTest.length;
							}
							
							if (count > 0) { 
								validLabResultsExist = true;
								$container.append(groupTemplate({folderTitle: name, listTitle: name, counter: count}));
								_.each(labTest, function(labData){
									$container.find("ul:last").append(itemTemplate(labData));
								});
							}
						});
					}
					
					if (validLabResultsExist) {
						that.detailsPage = new GraphView(that.LabGraph);
					} else {
						$container.append('<ul data-role="listview"></ul>').find('ul').append(itemTemplate({displayName: "No Data Found", noData: true}));
					}
					$container.trigger('create');
					
					$('#content-primary').find(":jqmData(role='header')").empty().append(primaryHeaderView.render(details)).trigger('create');
				}});
				
				return $container;
			},
			events: {
				"tap a.event-button": "viewGraph"
			},
			viewGraph: function(e){
				var item =  $(e.currentTarget),
					itemParent = item.parents('li'),
					url = item.attr('data-url'),
					searchTerm = item.attr('data-search-term');

				if(typeof url !== 'undefined'){
					$('#lab-list').find('li').removeClass('ui-btn-active');
					itemParent.toggleClass('ui-btn-active');
					$(document).jqmData('searchTerm', searchTerm);
					$(document).jqmData('graphURL', url);
					this.detailsPage.render();
					this.detailsPage.renderGraph();
					Global.getUtilities().slidePrimary();
				}
			}
		});
		return LabResultsListView;
	});