define([
	'Global',
	'LabTest',
	'Text!../../modules/html/templates/panes/labResult.html'
	],
	function(Global, LabTest, labResultsTemplate) {
		var LabResultsDetailsView = Backbone.View.extend({
			initialize: function(labType) {
				this.template = _.template(labResultsTemplate);
			},
			render: function(url) {
				var $container = $(this.el),
					template = this.template,
					scope = this;
					
				var labTest = new LabTest();

				$('#content-primary .scrollable').empty().append(template);

				labTest.fetch({
					url: url,
					success: function(model){
						scope.drawChart(model.get('labResult'));
					}
				});
				
			},
			drawChart: function(data){

				// define the options
				var options = {

					chart: {
						renderTo			: 'labtest-graph',
						backgroundColor		: 'transparent',
						plotBackgroundColor	: {
						linearGradient: [500, 0, 500, 500],
							stops: [
								[0, '#050a28'],
								[1, '#09144f']
							]
						},
						plotBorderColor		: '#f0c67a',
						plotBorderWidth		: 3,
						spacingRight		: 15,
						spacingLeft			: 15,
						spacingBottom		: 15,
						marginBottom		: 40,
						marginRight			: 30,
						marginLeft			: 30,
						zoomType			: 'x'
					},
					title: {
						text: null,
						align: 'left'
					},
					subtitle: {},
					credits: {
						enabled: false
					},

					xAxis: {
						type: 'datetime',
						maxZoom: 2628000000, // one month
						tickWidth: 0,
						gridLineWidth: 1,
						gridLineColor: '#1e233e',
						style: {
							overflow: 'visible'
							},
						labels: {
							align: 'left',
							x: 3,
							y: 15,
							opposite: true,
							style: {
								color: '#fff'
							}
						}
					},

					yAxis: [{ // left y axis
						title: {
							text: null
						},
						style: {
								overflow: 'visible'
							},
						labels: {
							align: 'right',
							x: -10,
							y: 16,
							opposite: true,
							style: {
								color: '#fff'
							},
							formatter: function() {
								return Highcharts.numberFormat(this.value, 0);
							}
						},
						gridLineColor: '#1e233e',
						showFirstLabel: false,
						plotBands: {
							from: 0,
							to:	0,
							color: '#442e24',
							label: {
								text: ''
							}
						}
					}, { // right y axis
						linkedTo: 0,
						gridLineWidth: 0,
						opposite: true,
						title: {
							text: null
						},
						labels: {
							align: 'left',
							x: 10,
							y: 16,
							opposite: true,
							style: {
								color: '#fff'
							},
							formatter: function() {
								return Highcharts.numberFormat(this.value, 0);
							}
						},
						showFirstLabel: false
					}],

					legend: {
						align: 'right',
						verticalAlign: 'top',
						y: 0,
						floating: true,
						borderWidth: 0,
						enabled: false,
						color: 'white'
					},

					tooltip: {
						shared: true,
						crosshairs: true
					},

					plotOptions: {
							
						line: {
							cursor: 'pointer',
							
							marker: {
								lineWidth: 1.5,
								lineColor: '#1a2148'
							},
							lineWidth: 1
						},
						series: {
							states: {
								hover: {
									enabled: true,
									lineWidth: 1
								}
							},
							marker: {
								states: {
									hover: {
										fillColor: '#FFFFFF'
									}
								}
							}
						}
					},
					series: [{
						type: 'line',
						name: 'WBC',
						tickInterval: 2628000000 * 3, // Three months
						color: '#7a9af6'
					}]
				};
				var lab = [],
					value = '',
					date = '',
					name = '',
					units = '',
					plotBandLow = 0,
					plotBandHigh = 0;

				var size = data.length;
				for (var i=size-1; i>=0; i--) {
					value = parseInt(data[i].value);
					date = new Date(data[i].resultedDate);
					lab.push([
						date.getTime(), value
					]);
				}
				units = data[0].valueUnits;
				name = data[0].testname + ' (' + data[0].specimenName+ ')';
				plotBandLow = data[0].referenceHigh;
				plotBandHigh = data[0].referenceLow;
				
				$('#content-primary .scrollable legend').text(name);
				
				options.series[0].name = units;
				options.yAxis[0].plotBands.from = plotBandLow;
				options.yAxis[0].plotBands.to = plotBandHigh;
				options.series[0].data = lab;
				chart = new Highcharts.Chart(options);

			}
		});
		 
		return LabResultsDetailsView;
	}
);