define([
	'Global',
    'HospitalEvent',
	'Text!../../modules/html/templates/panes/hospitalEventDetails.html',
	'Text!../../modules/html/templates/panes/notesSection.html'
	],
	function(Global, hospitalEvent, hospitalEventTemplate, notesSectionTemplate) {
		var HospitalEventDetail = Backbone.View.extend({
			tagName: 'div',
			id: 'clinic-event-details',
			model: hospitalEvent,
			attributes: {"class": "content-primary ui-btn-up-b", "data-tap-toggle": "false"},
			initialize: function() {
				this.template = _.template(hospitalEventTemplate);
				this.notesTemplate = _.template(notesSectionTemplate);
			},
			render: function(uri) {
				var template = this.template,
					notesTemplate = this.notesTemplate,
					container = $('#content-primary .scrollable');

				var newEvent = new hospitalEvent();

				container.empty();

				newEvent.fetch({
					async: false,
					url: uri
				});
				
				container.append(template(newEvent.toJSON()));
				container.append(notesTemplate(newEvent.toJSON()));
			}
		});
		
		return HospitalEventDetail;
	}
);