define([
	'Global',
	'DateRange',
	'Durations',
	'Duration',
	'DrawChartView',
	'Text!../../modules/html/templates/navbars/primaryDateTabs.html',
	'Text!../../modules/html/templates/menus/customDateMenu.html'
],
	function(Global, dateRange, durations, Duration, DrawChartView, dateRangeTabsTemplate, customDateMenu){
		var GraphView = Backbone.View.extend({
			initialize: function(dataObject){
				this.dateRangeTabsTemplate = _.template(dateRangeTabsTemplate);
				this.customTemplate = _.template(customDateMenu);
				this.date = dateRange;
				this.dataObject = dataObject;
			},
			render: function(){
				var primaryView = $('#content-primary').find('.scrollable'),
					customTemplate = this.customTemplate,
					container = $(this.el),
					dateRangeTabsTemplate = this.dateRangeTabsTemplate,
					timeSpan = $('#date-range-selection');

				if(!timeSpan.html()){
					primaryView.empty();
					container.empty();
					container.append(dateRangeTabsTemplate(durations));
					container.append(customTemplate({endDate: produceDate(0)}));
					container.append("<div id='graph-area'></div>");
					this.date.unbind('change');
					this.date.bind('change', this.change, this);
					primaryView.append(container).trigger("create");

					this.resetCustomDateMenu();
					dateRange.set(dateRange.defaults, {silent: true});
					$('#date-range-selection a.default').addClass('ui-btn-active');
				} else {
					primaryView.append(container).trigger("create");
				}
			},
			resetCustomDateMenu: function() {
				$('#date-from').val('');
				$('#date-to').val(formatDate(new Date()));
			},
			events: {
				"tap #date-range-selection a": "changeRange"
			},
			changeRange: function(e){
				e.preventDefault();
				var itemClicked = $(e.currentTarget),
					dateRange = itemClicked.attr('data-start-date');
				if (itemClicked.hasClass('custom')) {
					this.addCustomDate();
				} else {
					this.date.changeDateRange(dateRange);
				}
			},
			addCustomDate: function(e){
				var dateMenu = $('#custom-date-menu'),
					dateObject = this.date,
					scope = this;

				dateMenu.popup('open').trigger("create");
				var restrictDate = function(){
					var endDay = new Date($('#date-to').val()),
						today = new Date(),
						diff = parseInt((endDay - today) / 24 / 60 / 60 / 1000, 10);
					$('#date-from').data('datebox').options.maxDays = diff;
					$('#date-from').data('datebox').options.minDays = (diff * -1) + 2190; //6 years
				};

				restrictDate();
				$('#custom-date-menu-popup').on('change', '#date-to, #date-from', function(){
					var dateFrom = $('#date-from');

					if(new Date(this.value) < new Date(dateFrom.val())){
						dateFrom.val('');
					}
					if(this.value.length > 0 && dateFrom.val().length > 0){
						$('#add-custom-date').removeClass('ui-disabled');
					}
					else{
						$('#add-custom-date').addClass('ui-disabled');
					}
					restrictDate();
				});

				$(dateMenu).bind({
					popupafterclose: function(){
						var title = $('.ui-datebox-container').find('.ui-header h1').text().toLowerCase();
						$('#date-' + title).datebox('close');
						$('#add-custom-date').unbind();
					}
				});
				$('#add-custom-date').bind('tap', function(e){

					e.preventDefault();
					var duration = new Duration($(this).parents('form').formParams());
					var unformattedToDate = duration.get('endDate');

					//find difference between the two dates in days
					var dateDiff = ((((new Date(unformattedToDate) - new Date(duration.get('startDate'))) / 1000) / 60) / 60) / 24;

					dateObject.changeCustomDateRange(dateDiff, unformattedToDate);
					dateMenu.popup('close');

				});
			},
			renderGraph: function(){
				var container = $('#graph-area').empty(),
					graphData = new this.dataObject(),
					drawChartView = new DrawChartView(),
					url = this.createURL(),
					scope = this;

				graphData.fetch({
					url: url,
					success: function(model){
						if(typeof model.graphData[0] === "undefined"){
							scope.appendError();
						}
						else{
							container.append(drawChartView.render(model));
						}
					},
					error: function(){
						scope.appendError();
					}
				});
			},
			appendError: function(){
				$('#graph-area').empty().html('<p class="error-message">No Data Found Within the Specified Date Range</p>');
			},
			createURL: function(){
				var url = $(document).jqmData('graphURL');
				return url + "&startDate=" + formatDate(this.date.get('startDate')) + "&endDate=" + formatDate(this.date.get('endDate'));
			},
			change: function() {
				this.renderGraph();
			}
		});
		return GraphView;
	}
);