define([
	'Global',
	'Text!../../modules/html/templates/panes/eula.html',
	'Text!../../modules/html/templates/panes/eulaFooter.html'
],
	function (Global, eulaTemplate, eulaFooterTemplate) {
		var EulaView = Backbone.View.extend({
			id: 'eula',
			tagName: 'div',
			attributes: {'data-role': 'dialog'},
			initialize: function () {
				this.template = _.template(eulaTemplate);
				this.footerTemplate = _.template(eulaFooterTemplate); //needs to be decoupled so HTML doesn't have buttons
			},
			render: function () {
				var container = this.$el,
					template = this.template;
				container.empty().append(template).append(this.footerTemplate);
				$('body').append(container);
			},
			events: {
				'tap #accept-btn': 'acceptEula',
				'tap #decline-btn': 'declineEula',
				'tap .ui-header a[Title="Close"]': 'declineEula'
			},
			acceptEula: function () {
				var location = this.options.location.replace('#', '');
				Global.getUtilities()
					.writeToStorage(window.location.pathname +
					'eula', {
						dateAccepted: new Date().getTime()});
				if (location === 'eula' || location === "") {
					location = '*actions';
				}
				Global.getUtilities().eventAggregator.trigger(location);
			},
			declineEula: function (e) {
				e.preventDefault();
				var referencePath = Global.getUtilities().getReferencePath();
				if (typeof this.options.destination !== 'undefined' && this.options.destination === 'clear') {
					$('body').empty();
				} else {
					window.location = referencePath + '../launchpad';
				}
			}
		});
		return EulaView;
	}
);
