define([
	'Global',
	'HighCharts',
	'Text!../../modules/html/templates/panes/standardGraph.html'
],
	function(Global, HighCharts, labResultsTemplate){
		var DrawChartView = Backbone.View.extend({
			initialize: function(){
				this.template = _.template(labResultsTemplate);
			},
			render: function(graphData){
				var template = this.template,
					container = $('#graph-area');

				container.empty().append(template(graphData));

				this.drawChart(graphData);
			},
			drawChart: function(graphData){
				data = graphData.graphData;
				graphType = graphData.graphType;
				// define the options
				var options = {

					chart: {
						renderTo: 'graph',
						backgroundColor: 'transparent',
						plotBackgroundColor: {
							linearGradient: [500, 0, 500, 500],
							stops: [
								[0, '#050a28'],
								[1, '#09144f']
							]
						},
						plotBorderColor: '#f0c67a',
						plotBorderWidth: 3,
						spacingRight: 15,
						spacingLeft: 15,
						marginBottom: 40,
						marginRight: 40,
						marginLeft: 40,
						zoomType: 'x'
					},
					title: {
						text: null,
						align: 'left'
					},
					subtitle: {},
					credits: {
						enabled: false
					},

					xAxis: {
						type: 'datetime',
						minRange: 3600000, // one month
						tickWidth: 0,
						gridLineWidth: 1,
						gridLineColor: '#1e233e',
						style: {
							overflow: 'visible'
						},
						labels: {
							align: 'center',
							x: 3,
							y: 15,
							opposite: true,
							style: {
								color: '#fff'
							}
						}
					},

					yAxis: [
						{ // left y axis
							title: {
								text: null
							},
							style: {
								overflow: 'visible'
							},
							labels: {
								align: 'right',
								x: -10,
								y: 0,
								opposite: true,
								style: {
									color: '#fff'
								},
								formatter: function(){
									return Highcharts.numberFormat(this.value, 1);
								}
							},
							gridLineColor: '#1e233e',
							showFirstLabel: false
						},
						{ // right y axis
							linkedTo: 0,
							gridLineWidth: 0,
							opposite: true,
							title: {
								text: null
							},
							labels: {
								align: 'left',
								x: 10,
								y: 0,
								opposite: true,
								style: {
									color: '#fff'
								},
								formatter: function(){
									return Highcharts.numberFormat(this.value, 1);
								}
							},
							showFirstLabel: false
						}
					],

					legend: {
						enabled: false
					},

					tooltip: {
						shared: true,
						crosshairs: true,
						borderWidth: 1.2,
						formatter: function(){

							if(graphType === 'lineRangeGraph'){
								var s = '<span style="font-size: 1.5em; font-weight: bolder; line-height: .9em">' +this.points[1].y+ '/' + this.points[0].y + '</span><span style="color:' + this.points[1].series.color + '"> ' + this.points[1].series.name + '</span>';
							}
							else{
								var position = this.points.length - 1;
								var s = '<span style="font-size: 1.5em; font-weight: bolder; line-height: .9em">' + this.points[position].y + '</span><span style="color:' + this.points[position].series.color + '"> ' + this.points[position].series.name + '</span>';
							}
							s += '<br/><span style="">' + formatDate(this.x) + ' ' + formatTime(this.x) + '</span>';
							return s;
						},
						footerformat: "",
						style: {
							'text-shadow': 'none',
							'padding': '10px',
							'margin': '0'
						}
					},

					plotOptions: {

						line: {
							cursor: 'pointer',
							marker: {
								lineWidth: 1.5,
								lineColor: '#1a2148'
							},
							lineWidth: 1
						},
						series: {
							states: {
								hover: {
									enabled: true,
									lineWidth: 1
								}
							},
							marker: {
								states: {
									hover: {
										fillColor: '#FFFFFF'
									}
								}
							}
						}
					},
					series: [
						{
							type: 'arearange',
							name: 'Reference',
							tickInterval: 2628000000 * 3, // Three months
							color: '#442e24',
							data: {
								marker: {
									enabled: false
								}
							}
						},
						{
							type: 'line',
							name: 'Labs',
							tickInterval: 2628000000 * 3, // Three months
							color: '#7a9af6'
						},
						{
							type: 'arearange',
							name: 'Reference',
							tickInterval: 2628000000 * 3, // Three months
							color: '#442e24',
							data: {
								marker: {
									enabled: false
								}
							}
						},
						{
							type: 'line',
							name: 'Labs',
							tickInterval: 2628000000 * 3, // Three months
							color: '#7a9af6'
						}
					]
				};
				if(graphType === 'lineRangeGraph'){
					var referenceHigh = data[0][0].referenceLine,
						referenceLow = data[1][0].referenceLine;
					options.yAxis[0].plotLines = [
						{
							value: referenceHigh,
							color: '#CCC',
							dashStyle: 'longdash',
							width: 2
						},
						{
							value: referenceLow,
							color: '#CCC',
							dashStyle: 'longdash',
							width: 2
						}
					]
					options.yAxis[0].maxRange = referenceHigh +10;
					options.yAxis[0].minRange = referenceLow -10;
				}
				for(var c = 0; c < data.length; c++){
					var series = c * 2;

					var lab = [],
						reference = [],
						value = '',
						date = '',
						name = '',
						units = '',
						plotBandLow = 0,
						plotBandHigh = 0,
						size = data[c].length;

					for(var i = size - 1; i >= 0; i--){

						value = parseFloat(data[c][i].value);
						plotBandLow = parseFloat(data[c][i].plotBandLow);
						plotBandHigh = parseFloat(data[c][i].plotBandHigh);
						date = new Date(data[c][i].date);

						if(value == value){
							lab.push([
								date.getTime(), value
							]);
						}
						if(plotBandLow == plotBandLow && plotBandHigh == plotBandHigh){
							reference.push([
								date.getTime(), plotBandLow, plotBandHigh
							]);
						}
					}

					units = data[c][0].valueUnits;
					options.series[series + 1].name = units;
					options.series[series + 1].data = lab;
					options.series[series].data = reference;

				}

				chart = new Highcharts.Chart(options);
				Highcharts.setOptions({
					global: {
						useUTC: false
					}
				});
			}
		});

		return DrawChartView;
	}
);
