define([
	'Global',
	'Duration',
	'DateRange',
	'Text!../../modules/html/templates/menus/customDateMenu.html'
],
	function(Global, Duration, DateRange, customDateMenu){
		var CustomDateRange = Backbone.View.extend({
			initialize: function(){
				this.customTemplate = _.template(customDateMenu);
			},
			render: function(){
				var primaryView = $('#content-primary .scrollable'),
					customTemplate = this.customTemplate,
					container = $(this.el);

					container.empty();
					container.append(customTemplate({endDate: produceDate(0)}));
					primaryView.append(container).trigger("create");
					$('#date-range-selection a.default').addClass('ui-btn-active');

			},
			addCustomDate: function(e){
				var dateMenu = $('#custom-date-menu'),
					dateObject = new DateRange();

				dateMenu.popup('open').trigger("create");
				var restrictDate = function(){
					var endDay = new Date($('#date-to').val()),
						today = new Date(),
						diff = parseInt((endDay - today) / 24 / 60 / 60 / 1000, 10);
					$('#date-from').data('datebox').options.maxDays = diff;
					$('#date-from').data('datebox').options.minDays = (diff * -1) + 2190; //6 years
				};

				restrictDate();
				$('#custom-date-menu-popup').on('change', '#date-to, #date-from', function(){
					var dateFrom = $('#date-from');

					if(new Date(this.value) < new Date(dateFrom.val())){
						dateFrom.val('');
					}
					if(this.value.length > 0 && dateFrom.val().length > 0){
						$('#add-custom-date').removeClass('ui-disabled');
					}
					else{
						$('#add-custom-date').addClass('ui-disabled');
					}
					restrictDate();
				});

				$(dateMenu).bind({
					popupafterclose: function(){
						var title = $('.ui-datebox-container').find('.ui-header h1').text().toLowerCase();
						$('#date-' + title).datebox('close');
						$('#add-custom-date').unbind();
					}
				});
				$('#add-custom-date').bind('tap', function(e){

					e.preventDefault();
					var duration = new Duration($(this).parents('form').formParams());
					var unformattedToDate = duration.get('endDate');

//find difference between the two dates in days
					var dateDiff = ((((new Date(unformattedToDate) - new Date(duration.get('startDate'))) / 1000) / 60) / 60) / 24;

					dateMenu.popup('close');
					return dateObject.changeCustomDateRange(dateDiff, unformattedToDate);

				});
			}
		});
		return new CustomDateRange();
	}
);