define([
	'Global',
	'Modules',
	'MhpUser',
	'Patient',
	'secondaryHeaderView',
	'PastEventsList',
	'pastEventDetailsView',
	'HospitalEventsList',
	'hospitalEventDetailsView',
	'Text!../../modules/html/templates/lists/collapsibleFolder.html',
	'Text!../../modules/html/templates/lists/collapsibleListItem.html'
],
	function(Global, Modules, MhpUser, Patient, SecondaryHeaderView, PastEventsList, PastEventDetail, HospitalEventsList, HospitalEventDetail, folderTemplate, ClinicalEventsTemplate){

		var folderTemplate = _.template(folderTemplate),
			ClinicalEventsTemplate = _.template(ClinicalEventsTemplate),
			loadClinicEvents = function (container) {
				var user = Patient.instance(),
					pastEvents = new PastEventsList(),
					hospitalEvents = new HospitalEventsList(),
					actions = {title: Modules.getConstants().CLINIC_EVENTS_TITLE},
					sectionContainer = $('#content-secondary .scrollable'),
					secondaryHeaderView = new SecondaryHeaderView();

				pastEvents.fetch({
					url: user.get('patient-appointments-past').href,
					success: function(response){
						pastEventCount = response.length;
						container.prepend(folderTemplate({folderTitle: 'Past Kept Appointments', listTitle: 'pastAppointments', counter: pastEventCount}));
						if(pastEventCount > 0){
							pastEvents.each(function(pastEvent){
								container.find('[id = "pastAppointments"]').append(ClinicalEventsTemplate(pastEvent.toJSON()));
							});
						} else{
							container.find('[id = "pastAppointments"]').append(ClinicalEventsTemplate({header: 'No data found', subHeader: "", clickHandler: "noData", noteLink: ""}));
						}
						
						if (container.hasClass('ui-listview')) {
							container.listview('refresh');
						} 
						else {
							container.trigger('create');
						}
					}
				});
				hospitalEvents.fetch({
					url: user.get('patient-admisions').href,
					success: function(response){
						hospitalEventCount = response.length;
						container.append(folderTemplate({folderTitle: 'Hospitalizations', listTitle: 'hospitalizations', counter: hospitalEventCount}));
						if(hospitalEventCount > 0){
							hospitalEvents.each(function(hospitalEvent){
								container.find('[id = "hospitalizations"]').append(ClinicalEventsTemplate(hospitalEvent.toJSON()));
							});
						} else{
							container.find('[id = "hospitalizations"]').append(ClinicalEventsTemplate({header: 'No data found', subHeader: "", clickHandler: "noData", noteLink: ""}));
						}
						if (container.hasClass('ui-listview')) {
							container.listview('refresh');
						} 
						else {
							container.trigger('create');
						}
					}
				});
	
				secondaryHeaderView.render(actions);
				sectionContainer.empty().append(container);
				container.trigger('create');
			};
	
		var View = Backbone.View.extend({
			tagName: 'div',
			id: 'clinical-event-list',
			attributes: {},
			initialize: function(){
			},
			render: function(){
				var container = this.$el;
				
				$('#content-primary .scrollable').empty();
				
				if (Patient.instance().isValid()) {
					loadClinicEvents(container);
				} else {
					Patient.instance().fetch({
						url: MhpUser.instance().get('patient').href,
						success: function(response) {
							Global.getUtilities().flattenLinks(response);
							loadClinicEvents(container);
						}
					});
				}
				
				return this;
			},
			events: {
				"tap .event-button": "tapAppointment"
			},
			tapAppointment: function(e){
				e.preventDefault();
				var eventType = $(e.currentTarget).attr('data-type'),
					itemParent = $(e.currentTarget).parents('li'),
					detailsPage;

				itemParent.parents('#clinical-event-list').find('li.ui-btn-active').removeClass('ui-btn-active');
				itemParent.toggleClass('ui-btn-active');

				if(eventType !== "noData"){
					if(eventType === "hospital-event"){
						detailsPage = new HospitalEventDetail();
					}
					else{
						detailsPage = new PastEventDetail();
					}
					detailsPage.render($(e.currentTarget).attr('data-url'));
					Global.getUtilities().slidePrimary();
				}
			}

		});
		return View;
	}
);