define([
	'Global',
	'Resources',
	'User'],

	function(Global, Resources, user) {
		var utilities = { };

		/* Modules for Patient Summary secondary list view */
		utilities.addPosition = function() {
			var parsedHTML = $('#content-primary').find('.expander'),
				size = parsedHTML.length;
			for (var i=0; i<size; i++) {
				var position = parsedHTML[i].offsetTop;
				
				$(parsedHTML[i]).attr('data-offset', position);
			}
		};

		var CONSTANTS = {
			PATIENT_SEARCH_TITLE	: 'Patient Search',
			
			SECTION_LIST_TITLE  	: 'Sections',
			CLINIC_EVENTS_TITLE		: 'Clinic Events',
			LAB_RESULTS_TITLE		: 'Lab Results',
			RADIOLOGY_TITLE			: 'Radiology',
			MEDICATIONS_TITLE		: 'Medications',

			LAB_RESULTS_GRAPH_TAB	: 'Graph',
			LAB_RESULTS_TIME_TAB	: 'Time',
			RAD_RECENT_TAB			: 'Sort by Most Recent',
			RAD_GROUPED_TAB			: 'Sort Alphabetically',

			// TODO: Refactor this. Not a Tab!!
			VITAL_SIGNS_TAB			: 'Vital Signs',

			DEFAULT_LEFT_ACTION		: {
				id: '',
				href: '#',
				name: '',
				theme: 'd',
				icon: 'arrow-l',
				noText: false

			},
			DEFAULT_RIGHT_ACTION	: {
				id: '',
				href: '#',
				name: '',
				theme: 'd',
				icon: 'add',
				noText: false
			}
		};

		return {
			getUtilities: function() {
				return utilities;
			},
			getConstants: function() {
				return CONSTANTS;
			}
		}
	}
);