define([
	'Backbone',
	'Global'
	],
	function(Backbone, Global) {
		var MedFilter = Backbone.Model.extend({
			defaults: {
				"statuses":"ACTIVE",
				"sourceSystems":["VA","Non-VA"],
				"medicationSources":"OUTPATIENT",
				"startDate": subtractFromDate(0, 0, 1, 0, 0, 0, 0, new Date()),
				"endDate": formatDate(new Date()),
				"resultCount":"25"
			},
			queryParameters: function() {

				var statuses = this.get('statuses'),
					sourceSystems = this.get('sourceSystems'),
					medicationSources = this.get('medicationSources'),
					startDate = this.get('startDate'),
					endDate = this.get('endDate'),
					resultCount = this.get('resultCount'),
					q;

				// construct query parameter string
				q = "?";
				if (typeof statuses !== "undefined" && statuses !== "" && statuses) {
					q = q + "statuses=" + statuses + "&";
				}
				if (typeof sourceSystems !== "undefined" && sourceSystems !== "" && sourceSystems) {
					q = q + "sourceSystems=" + sourceSystems + "&";
				}
				if (typeof medicationSources !== "undefined" && medicationSources !== "" && medicationSources) {
					q = q + "medicationSources=" + medicationSources + "&";
				}
				if (typeof startDate !== "undefined" && startDate !== "" && startDate) {
					q = q + "startDate=" + startDate + "&";
				}
				if (typeof endDate !== "undefined" && endDate !== "" && endDate) {
					q = q + "endDate=" + endDate + "&";
				}
				if (typeof resultCount !== "undefined" && resultCount !== "" &&
					resultCount !== "Choose options" && resultCount) {
					q = q + "resultCount=" + resultCount + "&page=1&";
				}
				return q.slice(0, -1);
			}
		});
		return new MedFilter();
	}
);