define(
	['Global'],
	function(Global) {
		var HospitalEvent = Backbone.Model.extend({
			defaults:{
            	"facilityName":"",
            	"admittingProviderName":"",
            	"title":"Discharge Notes"
			},
			initialize:function(){
			},
			parse: function(collection){
                var appointmentDate = collection.appointmentStartDate,
                	dateIn = collection.admissionDate,
					dateOut = collection.dischargeDate,
					dischargeNote = collection.dischargeSummary;

				if( typeof appointmentDate !== "undefined")
					collection.date = (formatDate(appointmentDate) + ", " + formatTime(appointmentDate));
				if( typeof dateIn !== "undefined")
					collection.dateIn = (formatDate(dateIn));
				if( typeof dateOut !== "undefined")
					collection.dateOut = (formatDate(dateOut));
                if( typeof dischargeNote !== "undefined")
					collection.note = collection.dischargeSummary;

				return collection;
			}
		});
		return HospitalEvent;
	}

);

