define(
	['Backbone', 'Utilities'],
	function(Backbone, Utilities) {
		var Duration = Backbone.Model.extend({
			initialize: function() {
				if (this.get('duration') > 0) {
					this.set({
						'startDate': produceDate(this.get('duration')),
						'endDate': produceDate(0)
					});
				} else if (this.get('durationInMonths') > 0) {
					this.set({
						'startDate': produceDateFromMonths(this.get('durationInMonths')),
						'endDate': produceDate(0)
					});
				} else if (this.get('durationInDays') > 0) {
					this.set({
						'startDate': produceDateFromDays(this.get('durationInDays')),
						'endDate': produceDate(0)
					});
				}
			},
		});
		return Duration;
	}
);