define([
	'Global'
],
	function(Global){
		var DateRangeObject = Backbone.Model.extend({
			defaults: {
				"endDate": new Date(),
				"startDate": subtractFromDate(24, 0, 0, 0, 0, 0, 0, new Date())
			},
			changeDateRange: function(start){
				this.set({
					"endDate": new Date(),
					"startDate": start
				});
			},
			changeCustomDateRange: function(end, start){

				//assuming endDate is unformatted, subtracts days
				this.set({"endDate": new Date(start), "startDate" : subtractFromDate(0, parseInt(end, 10), 0, 0, 0, 0, 0, this.get("endDate"))});

			}

		});
		return new DateRangeObject();
	}
);



