define([
    'Backbone',
	'VitalsGraphPoint'
	],
	function(Backbone, VitalsGraphPoint) {
		var VitalsGraph = Backbone.Collection.extend({
			model: VitalsGraphPoint,
			defaults: {
				"title": "",
				"graphType": undefined
			},
			initialize: function(){
			},
			parse: function(response){
				var data = response.dataSeries;
				$(data).each(function(graphLine){
					$(data[graphLine].item).each(function(point){
						data[graphLine].item[point].minY = parseFloat(data[graphLine].minY);
						data[graphLine].item[point].maxY = parseFloat(data[graphLine].maxY);
					});
				})
				var graphDataArray = new Array();
				for(var i=0; i< data.length; i++)
				{
					graphDataArray.push(data[i].item);
				}
				this.graphData = graphDataArray;
				this.title = response.graphTitle;
				if(response.graphTitle.toLowerCase() === "blood pressure")
				{
					this.graphType = "lineRangeGraph"
				}
				return data;
			}

		});
		return VitalsGraph;
	}
);



