define([
	'Backbone',
	'Global',
	'App',
	'Patient',
	'TimeReport'
	],
	function(Backbone, Global, App, Patient, MicrobiologyReport) {
		var TimeReportsByGroup = Backbone.Collection.extend({
			model: MicrobiologyReport,
			url:"",
			initialize: function(name) {
				this.name = name;
				var patient = Patient.instance();
				this.url = patient.get(App.defineResourceTitles().timeReportsByGroupTitle).href;
				this.fetch({async: false});
			},
			parse: function(response) {
				return response.labTestGroup;
			}
		});

		return TimeReportsByGroup;
	}
);