define([
	'Backbone',
	'Global',
	'Patient',
	'Radiology'
	],
	function(Backbone, Global, Patient, Radiology) {
		var RadiologyByType = Backbone.Collection.extend({
			model: Radiology,
			url:"",
			initialize: function(name) {
				this.name = name;
				var patient = Patient.instance();
				this.url = patient.get('patient-radiology-tests').href;
				this.fetch({async: false});
			},
			parse: function(response) {
				return response.radiologyTest;
			},
			comparator: function(model) {
				return model.get('testName');
			}
		});

		return RadiologyByType;
	}
);