define([
	'Backbone',
	'Global',
	'Patient',
	'Radiology'
	],
	function(Backbone, Global, Patient, Radiology) {
		var RadiologyByRecent = Backbone.Collection.extend({
			model: Radiology,
			url:"",
			initialize: function() {
				var patient = Patient.instance();
				this.url = patient.get('patient-radiology-results').href;
				this.fetch({async: false});
			},
			parse: function(response) {
				return response.radiologyResult;
			}
		});

		return RadiologyByRecent;
	}
);