define([
	'Backbone',
	'Global',
	'App',
	'Patient',
	'MicrobiologyReport'
	],
	function(Backbone, Global, App, Patient, MicrobiologyReport) {
		var MicrobiologyReportsByGroup = Backbone.Collection.extend({
			model: MicrobiologyReport,
			url:"",
			initialize: function() {
				var patient = Patient.instance();
				this.url = patient.get(App.defineResourceTitles().microbiologyReportsByGroupTitle).href;
			},
			parse: function(response) {
				return response.labTestGroup;
			}
		});

		return MicrobiologyReportsByGroup;
	}
);