define([
	'Backbone',
	'LabGraphPoint'
],
	function(Backbone, LabTest){
		var LabGraph = Backbone.Collection.extend({
			model: LabTest,
			defaults: {
				"title": ""
			},
			initialize: function() {
			},
			parse: function(response){
				var graphDataArray = new Array();
				if(response.size > 0 ){
					var defaultModel = _.first(response.labResult);
					this.title = defaultModel.testname;

					var specimenName = defaultModel.specimenName;
					if(typeof specimenName !== "undefined"){
						this.title += " (" + specimenName + ")";
					}
					var graphDataArray = new Array();
					graphDataArray.push(response.labResult);

				}
				this.graphData = graphDataArray;
				return response.labResult;
			}
		});
		return LabGraph;
	}
);