define([
	'Backbone',
	'jQM',
	'footerView',
	'secondaryView',
	'primaryView',
	'Text!../../html/templates/common/main-doubleColumn.html'
	],
	function(Backbone, jQM, FooterView, secondaryView, primaryView, mainTemplate ) {
		var MainView = Backbone.View.extend({
			id: 'main',
			attributes: {'data-role': 'page', 'class': 'type-interior ui-page'},

			initialize: function() {
				this.mainTemplate = _.template(mainTemplate);
			},

			render: function() {

				var container = $(this.el)
					.empty()
					.append(this.mainTemplate());

				container.find(":jqmData(role='content')")
						.append(primaryView.render())
						.append(secondaryView.render())
				.end().find(":jqmData(role='footer')")
					.append(
						new FooterView().render()
					);
				
				return container;
			}
		});

		return MainView;
	}
);