define(
	['Resources', 'Global'],
	function(resources, Global) {
		var singleInstance,
			MhpUser = Backbone.Model.extend({
			defaults: {
				"id":"",
				"lastName":"",
				"firstName":"",
				"displayName":"",
				"rightOfAccessAccepted":false,
				"link":"",
				"vistaLocation":"",
				"facilityName":""
			},
			initialize: function() {
				this.url = resources.get('mhpuser').get('href');
				this.fetch({async: false});
				Global.getUtilities().flattenLinks(this); 
			}
		});

		MhpUser.instance = function() {
			if (typeof singleInstance === "undefined") {
				singleInstance = new MhpUser();
			}
			return singleInstance;
		}

		return MhpUser;
	}
);