// tag each IE with an individual class;
jQuery(function($){
    if($.browser.msie) {
        var c = 'ie' + parseInt($.browser.version, 10);
        $('html').addClass(c);
    }
});

// initalize Uniform JS;
jQuery(function($){
    $('input, textarea, select, button').uniform();
});

// initalize Equal Heights JS
$(document).ready(function() {
//	debug.setLevel(0);	
	
	resizeSections('.apps-ipad');
	resizeSections('.apps-iphone');
	
	$(window).resize(function() {
		resizeSections('.apps-ipad');

		resizeSections('.apps-iphone');
	});
		
	// adding icon to install links
	$('cite a.itunes').append('<img src="resources/_assets/img/interface/icon_itunes.gif" />');
	$('cite a.universal').append('<img src="resources/_assets/img/interface/icon_install.gif" />');
	$('cite a.normal').append('<img src="resources/_assets/img/interface/icon_install.gif" />');

	$('a.title').bind('click', function() {
		return false;
	});
	
	// heights of sections
//	makeRowsEqualHeight('.apps-ipad .row section');
//	makeRowsEqualHeight('.apps-ipad .row section div.padding');
	
	
});

function resizeSections(e) {
	var currentWidth = $(e).width();
	var totalApps = $('.row section', e).length;
	//console.log('current apps width: ' + currentWidth);

	
	// check to see how many apps.
	if (totalApps >= 7) {	// if it's more than 6 apps then it can stack okay.
		var idealWidth = currentWidth/3;
	
		$('section', e).width(idealWidth);
		
		
		var totalWidth = $('.row section', e).length / 2;
		totalWidth =  Math.round(totalWidth);
		//console.log('total number of sections: ' + totalWidth);
		
		$('.row', e).width(totalWidth * idealWidth);
		if( $('.pagination', e).length <= 0 ) { // attaching the scrolling icons
			$('.titlebar', e).append('<a href="" class="pagination next"><img src="resources/_assets/img/interface/icon_next.png" title="See more apps" /></a>');
			$('.titlebar', e).prepend('<a href="" class="pagination prev"><img src="resources/_assets/img/interface/icon_prev.png" title="See more apps" /></a>');
			$('.next', e).live('click', function() {
			
				var currentLeft 	= $('.navi', e).scrollLeft();
				var amountToScroll 	= currentLeft + idealWidth;
				
				//console.log('current Left: ' + currentLeft);
				//console.log('current Viewable: ' + idealWidth*3);
				
				$('.navi', e).animate({scrollLeft: amountToScroll}, 1000);
				return false;
			});
			$('.prev', e).bind('click', function() {
				var currentLeft 	= $('.navi', e).scrollLeft();
				var amountToScroll = 0;
				
				if(currentLeft <= idealWidth) {
					amountToScroll = -idealWidth;
				} else {
					amountToScroll 	= currentLeft - idealWidth;
				}
				
				
				//console.log('currentLeft is: ' + currentLeft);
				//console.log('the amount to scroll to hte left is: ' + amountToScroll);
				
				$('.navi', e).animate({scrollLeft: amountToScroll}, 1000);
				return false;
			});
		}
	} else if (totalApps == 6) {
		var idealWidth = currentWidth/3;
	
		$('section', e).width(idealWidth);
		
		
		var totalWidth = $('.row section', e).length / 2;
		totalWidth =  Math.round(totalWidth);
		//console.log('total number of sections: ' + totalWidth);
		
		$('.row', e).width(totalWidth * idealWidth);
		
	} else if (totalApps < 6 && totalApps >= 4) { // less than six. more than 4
		//console.log('going into the 4-6 range');
		var shim = '<section><div class="padding"></div></section>';
		var howMany = 6 - totalApps;
		//console.log('how many: ' + howMany);
		
		for (i=1; i <= howMany; i++) {
			$('.row', e).append(shim);
		}
		
		var idealWidth = currentWidth/3;
	
		$('section', e).width(idealWidth);
		
		
		var totalWidth = $('.row section', e).length / 2;
		totalWidth =  Math.round(totalWidth);
		//console.log('total number of sections: ' + totalWidth);
		
		$('.row', e).width(totalWidth * idealWidth);
		
	} else { // less than 4
		//console.log('going into the 1-3 range');
		var shim = '<section><div class="padding"></div></section>';
		var howMany = 3 - totalApps;
		//console.log('how many: ' + howMany);
		
		for (i=0; i <= howMany; i++) {
			$('.row', e).append(shim);
		}
		
		
		var idealWidth = currentWidth/3;
	
		$('section', e).width(idealWidth);
		
		
		var totalWidth = $('.row section', e).length;
		totalWidth =  Math.round(totalWidth);
		//console.log('total number of sections: ' + totalWidth);
		
		$('.row', e).width(totalWidth * idealWidth)
			.height('200px')
		$('.navi', e).height('200px').css('min-height', '200px');
		
	}
}
	