/* JS Document */

/**
*
* @project : Mobile Blue Button
* @version MBB/Version 1
* @package xhtml-css
* @author Benjamin Cushing
* @jsdoc version 1
*
*/



function globalInit(callbackFn) {
	parseTokenAndRegisterOauthHandler();
	m.fetchUserResources = function(){
		m.resources = new m.Resources();
		m.resources.fetch({async: false}); // BOOTSTRAP me!
		m.user = new m.User();
		m.user.fetch({
			async: false,
			success: function() {
				if ($.isFunction(callbackFn)) {
					callbackFn.call();
				}
			}
		});
	};

	//Check browser for compatibility
	browserAllowed();
	registerErrorHandling();

	//Check for accepted ROA
	m.fetchUserResources();
}

function resizePanes() {
	// headerHeight = $('.ui-page .ui-header').height();
	// footerHeight = $('.ui-page .ui-footer').height();
	
	$('.ui-content').height($(window).height() - 72);
}


function parseTokenAndRegisterOauthHandler() {
	var params = {}, queryString = location.search.substring(1),
    regex = /([^&=]+)=([^&]*)/g,
    m,
    hasTokenQueryParameter = false;
	
	while (m = regex.exec(queryString)) {
  		params[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
	}

	var token = params['token'];

	if(typeof token !== 'undefined' && token !== 'undefined' && token !== null && token !== 'null'){
		window.sessionStorage['token']=JSON.stringify(token);
		hasTokenQueryParameter = true;
	}
	
	var storedToken = window.sessionStorage['token'];

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	var closeConnectionError = function(){
		if($("#conection-lost").length > 0 && $("#conection-lost").css('display') !== 'none')
		{
			$("#conection-lost").dialog('close',{transition: "pop", domCache: true });
		}
	}
	var connectionError = function(){
		if($('#conection-lost').length === 0)
		{
			$('body').append('<div id="conection-lost" data-role="dialog"> \
										<div data-role="header" data-theme="d"> \
											<h2>Connection Error</h2> \
										</div> \
										<div data-role="content"> \
											<h3>Your internet appears to be unavailable. Please try again when you regain connectivity</h3>  \
											<button id="connection-lost-ok" data-theme="b">OK</button>\
										</div> \
									</div>').trigger('create');

		}
		$.mobile.changePage( "#conection-lost");
		$("#conection-lost").on('tap',function(){
			closeConnectionError();
		});
		$('#conection-lost a[title = "Close"]').on('tap',function(e){
			e.preventDefault();
			closeConnectionError();
		});
	};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	var closeConnectionEstablished = function(){
		if($("#conection-established").length > 0 && $("#conection-established").css('display') !== 'none')
		{
			$("#conection-established").dialog('close',{transition: "pop", domCache: true });
		}
	}
	var connectionEstablished = function(){
		if($('#conection-established').length === 0)
		{
			$('body').append('<div id="conection-established" data-role="dialog"> \
										<div data-role="header" data-theme="d"> \
											<h2>Reconnected</h2> \
										</div> \
										<div data-role="content"> \
											<h3>Your internet appears to be reconnected.  Thank you for you patience</h3>  \
											<button id="reconnect-ok" data-theme="b">OK</button>\
										</div> \
									</div>').trigger('create');

		}
		$.mobile.changePage( "#conection-established");
		$("#reconnect-ok").on('tap',function(){
			closeConnectionEstablished();
		});
		$('#conection-established a[title = "Close"]').on('tap',function(e){
			e.preventDefault();
			closeConnectionEstablished();
		});
	};
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	window.addEventListener("offline", function(e) {
		closeConnectionEstablished();
		setTimeout(function(){
			connectionError();
		},13)
	});
	window.addEventListener("online", function(e) {
		closeConnectionError();
		setTimeout(function(){
			connectionEstablished();
		},13)
	});

	if(typeof storedToken !== 'undefined' && storedToken !== 'undefined' && storedToken !== null && storedToken !== 'null'){
		$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
			var currentToken = JSON.parse(storedToken);

			jqXHR.setRequestHeader("Authorization", "Bearer " + currentToken);
		});
	} else {
		cleanUpSession();
	}

	if (hasTokenQueryParameter) {
		window.location = getReferencePathWithHash();
	}
}

function getReferencePath() {
	var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
	var index = referencePath.indexOf("index.html");
	if (index !== -1) {
		referencePath = referencePath.substring(0, index);
	}
	return referencePath;
};

function getReferencePathWithHash() {
	return getReferencePath() + '?url='+ getURLParam(window.location, 'url') + window.location.hash;
};
function checkForROA() {
	if (!m.user.get('rightOfAccessAccepted')){
		var url = window.location.pathname; 	
		window.location = '../roa/index.html?url=' + url;
		
		return false;
	}else{
		return true;
	}
}

/*____Browser Detection____*/
// http://caniuse.com/#feat=audio
// http://caniuse.com/#feat=audio

function browserAllowed(){
	if (!Modernizr.audio && navigator.userAgent.indexOf('PhantomJS') < 0) {
		$('body').css({
			'background-color': 'transparent',
			'background-image': 'url("../img/bg_app_main.jpg")',
			'background-position': 'center center',
			'background-size': '100%'
		});
		alert('Your browser does not support this application. Please upgrade your browser or device.\n\n');
		window.location = '../newbrowser.html';
	}
}

function registerErrorHandling() {
	$(document).ajaxError(function(e, jqxhr, settings, exception) {
		if ( jqxhr.status == 0 || jqxhr.status == 200 || jqxhr.status == 400 || jqxhr.status == 404) {
			
		} else if (jqxhr.status == 403) {
			cleanUpSession();
			if((window.location.pathname).indexOf("/MobileHealthPlatformWeb/roa/") !== -1){
                 		var params = {}, queryString = location.search.substring(1),
                	   	regex = /([^&=]+)=([^&]*)/g,
               			 m;
                		while (m = regex.exec(queryString)) {
                        		params[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
                		}

                		var url = params['url'];
                       		window.location = getReferencePath() + '../oauthlogin?redirect_uri=' + url;
                        } else {
                            	window.location = getReferencePath() + '../oauthlogin?redirect_uri=' + getReferencePathWithHash();
                        }
		} else if (jqxhr.status == 401) {
			if (jqxhr.responseText.indexOf('invalid_token') > 0) {
				cleanUpSession();
				$.ajax(settings);
			}
		} else {
			alert('unknown error in: ' + settings.url + '\nstatus code: ' + jqxhr.status + ' \nerror:\n' + jqxhr.responseText);
		}
	});
}

function cleanUpSession() {
	window.sessionStorage['token'] = null;
	$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
		jqXHR.setRequestHeader("Authorization", "");
	});
	deleteCookie('JSESSIONID');
}

function deleteCookie(cookieName) {
	document.cookie = encodeURIComponent(cookieName) + "=deleted; expires=" + new Date(0).toUTCString();
}

function loginRedirect(){
	window.location = '../login';
}

function getURLParam (oTarget, sVar) {
	  return decodeURI(oTarget.search.replace(new RegExp("^(?:.*[&\\?]" + encodeURI(sVar).replace(/[\.\+\*]/g, "\\$&") + "(?:\\=([^&]*))?)?.*$", "i"), "$1"));
}

	

