define(['jQuery', 'Resources'],

	function($, resources) {
		//Global should not have any dependencies
		var utilities = {},
			headerHeight,
			footerHeight;

		utilities.flattenLinks = function(object) {
			var links = object.get('link');
			if (typeof links !== 'undefined') {
				size = links.length;
				for (var i=0; i<size; i++) {
					if (links[i].title) {
						object.set(links[i].title,links[i]);
					} else {
						object.set('self',links[i]);
					}
				}
				object.unset('link');
			}
		};

		utilities.globalInit = function(app) {
			if (app.user) {
				if (!app.provider) {
					utilities.checkROA(app);
				}
				utilities.resizePanes();
				
				$(window).resize(utilities.resizePanes);
			}

			$('body').on('pageshow',function(event, ui) {
				var prevPage = $(ui.prevPage);
				if (prevPage.hasClass('ui-dialog')) {
					prevPage.remove();
				}

				utilities.resizePanes();
				utilities.registerLoadingSpinner();
			});
		};

		/*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		 TIMEOUT
		 ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/
		utilities.logoutWarning = function(app) {

			var logoutAfter,
				timeUnitText = "Minutes",
				diplayTimeUnits = 60000, // minutes
				showWarningInterval = 3 * diplayTimeUnits, //5
				showWarningTrigger = showWarningInterval + diplayTimeUnits,// show dialog on the threshold... show at 5:59 so they have a full 5 mins,
				showWarningMessageTimer,
				calcTimeout,
				sessionTimedout = false,
				warningTimer,
				timeoutDialogController = function(){
					$.ajax({
						url:resources.get('last-accesstime').toJSON().href,
						dataType: "json",
						success: function(item){
							clearTimeout(warningTimer);
							logoutAfter = item.timeToExpireInSeconds * 1000; //convert to miliseconds
							if(logoutAfter <= showWarningTrigger){
								showSessionWarning();
							}else if (typeof logoutAfter !== undefined){
								warningTimer = window.setTimeout(function(){
									timeoutDialogController();
								},logoutAfter - showWarningInterval)
							};
						}
					});
				};

			timeoutDialogController();

			var showSessionWarning = function(){
				var warningUpdateCounter = 1,
					warningMessageDisplayInterval = showWarningInterval, //900000 = 15 min
					countdownStart = warningMessageDisplayInterval/diplayTimeUnits;

				if($('#logout-warning').length === 0) {
					$('body').append(
						'<div id="logout-warning" data-role="dialog" data-close-btn="none"> \
							<div data-role="header" data-theme="d"> \
								<h2>Warning</h2> \
							</div> \
							<div data-role="content"> \
								<h3>Due to inactivity you will be logged out in <span id="countdown-session">' + countdownStart + '</span> '+ timeUnitText +'</h3>  \
										<p>Would you like to maintain your session?</p>  \
										<div class="ui-grid-a "> \
											<div class="ui-block-a"><button id="end-session" data-mini="true" data-theme="b">Exit</button></div> \
											<div class="ui-block-b"><button id="keep-session" data-mini="true" data-theme="b">Continue</button></div> \
										</div> \
									</div> \
								</div>'
					).trigger('create');
				}
				var logoutTimeout,
					timeRemaining = function(){
						var time = (warningMessageDisplayInterval - (diplayTimeUnits * warningUpdateCounter));

						if(time <= 0)
						{
							sessionTimedout = true;
							showTimeoutMessage();
						}
						return time;


					},
					changeCountdownText = function(){
						var timeLeft = timeRemaining();
						$('#countdown-session').text(parseInt(timeLeft, 10) / diplayTimeUnits);
						warningUpdateCounter++;
					},
					calculateCountdown = function(){
						$.ajax({
							url:resources.get('last-accesstime').toJSON().href,
							dataType: "json",
							success: function(item){
								logoutAfter = item.timeToExpireInSeconds * 1000; //convert to miliseconds
								if(logoutAfter > showWarningTrigger){
									$("#logout-warning").dialog('close',{transition: "pop"});
									timeoutDialogController();
								}
							}
						});
						clearTimeout(calcTimeout);
						calcTimeout = window.setTimeout(function(){
							if(!sessionTimedout)
							{
								changeCountdownText();
								calculateCountdown();
							}
						}, diplayTimeUnits)
					},
					logout = function() {
						utilities.cleanUpSession();
						var logoutUrl = resources.get('logout').get('href') + '?redirect_uri=' + Global.getUtilities().getReferencePath();
						$.ajax({
							url: resources.get('token').get('href'),
							type: 'DELETE',
							success: function(data){
								sessionStorage.clear();
								window.location = logoutUrl + "?"+(new Date()); // Prevent Safari Cacheing
							}
						});
					},
					showTimeoutMessage = function() {
						$("#logout-warning").on('pagehide', function() {
							showReconnectDialog();
						});
						utilities.cleanUpSession();
						$('#content-secondary .scrollable').empty();
						$('#content-primary .scrollable').empty();
						$("#logout-warning").dialog('close',{transition: "pop"});


					},
					showReconnectDialog = function() {
						$('body').append(
							'<div id="reconnect-dialog" data-role="dialog" data-close-btn="none"> \
								<div data-role="header" data-theme="d"> \
									<h2>Session Expired</h2> \
								</div> \
								<div data-role="content"> \
									<h3>Due to inactivity you have logged out</h3>  \
								<p>Select "Home" to return to your Launchpad or "Resume" continue from your previous page.</p>  \
								<div class="ui-grid-a "> \
									<div class="ui-block-a"><button id="return-home" data-mini="true" data-theme="b">Home</button></div> \
									<div class="ui-block-b"><button id="continue-session" data-mini="true" data-theme="b">Resume</button></div> \
								</div> \
							</div> \
						</div>'
						).trigger('create');
						$.mobile.changePage( "#reconnect-dialog",{transition: 'pop'});

						$("#reconnect-dialog").on('tap', 'a[title = "Close"], #return-home',function(){
							var logoutUrl = resources.get('logout').get('href') + '?redirect_uri=' + utilities.getReferencePath();
							$.ajax({
								url: resources.get('token').get('href'),
								type: 'DELETE',
								success: function(data){
									sessionStorage.clear();
									window.location = logoutUrl + "?"+(new Date()); // Prevent Safari Cacheing
								}
							});
						});
						$("#continue-session").on('tap',function(){
							window.location = utilities.getReferencePath() + window.location.hash;
						});
					};

				$.mobile.changePage( "#logout-warning",{transition: 'pop'});
				calculateCountdown();
				$("#logout-warning").on('tap', '#end-session, a[title = "Close"]',function(){
					var logoutUrl = resources.get('logout').get('href') + '?redirect_uri=' + utilities.getReferencePath();
					$.ajax({
						url: resources.get('token').get('href'),
						type: 'DELETE',
						success: function(data){
							sessionStorage.clear();
							window.location = logoutUrl + "?"+(new Date()); // Prevent Safari Cacheing
						}
					});
				});
				$("#keep-session").on('tap',function(){
					$("#logout-warning").on('pagehide', function() {
						timeoutDialogController();
					});
					$.ajax({
						url: app.user.url, //mhpuser
						success: function(){
							$("#logout-warning").dialog('close',{transition: "pop"});
							clearTimeout(calcTimeout);
						} //mhpuser
					});
				});
			}
		};
		utilities.slidePrimary = function() {
			var moveContent = $('#content-primary');
			if (moveContent.hasClass('closed')) {
				moveContent.removeAttr('style');
				moveContent.toggleClass('closed');
			} else {
				$('#content-primary').animate({
					left: '0'
				}, 300, function() {
					$(this).toggleClass('closed');
				});
			}
		};

		utilities.resizePanes = function() {
			if (typeof headerHeight === 'undefined' && $('#main .ui-header').height() !== null) {
				headerHeight = 42;
				footerHeight = 86;
			}
			//header and footer have lost relevence in soc
			$('#main .scrollable').height($(window).height() - headerHeight - footerHeight);
			utilities.eventAggregator.trigger('footer');
		};

		utilities.checkROA = function(app) {
            var rightOfAccessAccepted = true;
			if (typeof app.user !== 'undefined' && app.user.id) {
                rightOfAccessAccepted = typeof app.user.rightOfAccessAccepted !== 'undefined' ? app.user.rightOfAccessAccepted : app.user.attributes.rightOfAccessAccepted;
				if (!rightOfAccessAccepted) {
					window.location = utilities.getReferencePath() + '../roa/index.html?url=' + window.location.pathname;;
				}
			}
		};

		utilities.writeToStorage = function(key, value) {
			if (value) {
				try {
					window.localStorage[key] = JSON.stringify(value);
				} catch (e) {
					if (e == QUOTA_EXCEEDED_ERR) {
						var message = 'Local-Storage Quota exceeded!';
						if (window.console && window.console.log) {
							console.log(message);
						} else {
							alert(message);
						}
					}
				}
			}
		};

		utilities.readFromStorage = function(key) {
			var value = null;
			if (typeof(window.localStorage) != 'undefined') {
				value = JSON.parse(window.localStorage[key] || null);
			}
			return value;
		};

		utilities.checkEULA = function(prevHash, modifiedDate) {
			var url = window.location.pathname,
				value = utilities.readFromStorage(url + "eula");
			if (value === null || new Date(modifiedDate).getTime() > value.dateAccepted) {
				return "#eula";
			} else {
				return prevHash;
			}
		};

		utilities.getReferencePath = function() {
			var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
			var index = referencePath.indexOf("index.html");
			if (index !== -1) {
				referencePath = referencePath.substring(0, index);
			}
			return referencePath;
		};

		utilities.getReferencePathWithHash = function() {
			return encodeURI(utilities.getReferencePath() + window.location.hash);
		};

		utilities.deleteCookie = function(cookieName) {
			document.cookie = encodeURIComponent(cookieName) + "=deleted; expires=" + new Date(0).toUTCString();
		};
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var closeConnectionError = function(){
			if($("#conection-lost").length > 0 && $("#conection-lost").css('display') !== 'none')
			{
				$("#conection-lost").dialog('close',{transition: "pop", domCache: true });
			}
		};
		var connectionError = function(){
			if($('#conection-lost').length === 0)
			{
				$('body').append('<div id="conection-lost" data-role="dialog"> \
										<div data-role="header" data-theme="d"> \
											<h2>Connection Error</h2> \
										</div> \
										<div data-role="content"> \
											<h3>Your internet connection appears to be unavailable. Please try again when you regain connectivity</h3>  \
											<button id="connection-lost-ok" data-theme="b">OK</button>\
										</div> \
									</div>').trigger('create');

			}
			$.mobile.changePage( "#conection-lost");
			$("#conection-lost").on('tap',function(){
				closeConnectionError();
			});
			$('#conection-lost a[title = "Close"]').on('tap',function(e){
				e.preventDefault();
				closeConnectionError();
			});
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		var closeConnectionEstablished = function(){
			if($("#conection-established").length > 0 && $("#conection-established").css('display') !== 'none')
			{
				$("#conection-established").dialog('close',{transition: "pop", domCache: true });
			}
		}
		var connectionEstablished = function(){
			if($('#conection-established').length === 0)
			{
				$('body').append('<div id="conection-established" data-role="dialog"> \
										<div data-role="header" data-theme="d"> \
											<h2>Reconnected</h2> \
										</div> \
										<div data-role="content"> \
											<h3>Your internet appears to be reconnected.  Thank you for you patience</h3>  \
											<button id="reconnect-ok" data-theme="b">OK</button>\
										</div> \
									</div>').trigger('create');

			}
			$.mobile.changePage( "#conection-established");
			$("#reconnect-ok").on('tap',function(){
				closeConnectionEstablished();
			});
			$('#conection-established a[title = "Close"]').on('tap',function(e){
				e.preventDefault();
				closeConnectionEstablished();
			});
		};
		utilities.internetDisconnect = function() {
			var disconnected = false;
			$(document).ajaxSend(function(e, jqxhr, settings, exception) {
				if (!navigator.onLine) {
					connectionError();
					disconnected = true;
				} else if (disconnected === true) {
					connectionEstablished()
					disconnected = false;
				}
			});
		};
		utilities.internetDisconnect();

		utilities.cleanUpSession = function() {
			window.sessionStorage['token'] = null;
			$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
				jqXHR.setRequestHeader("Authorization", "");
			});
			utilities.deleteCookie('JSESSIONID');
		};

		utilities.parseTokenAndRegisterOauthHandler = function() {
			var hasTokenQueryParameter = false;
			var params = {}, queryString = location.search.substring(1),
			regex = /([^&=]+)=([^&]*)/g, m;
			while (m = regex.exec(queryString)) {
				params[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
			}

			var token = params['token'];

			if(typeof token !== 'undefined' && token !== 'undefined' && token !== null && token !== 'null'){
				window.sessionStorage['token']=JSON.stringify(token);
				hasTokenQueryParameter = true;
			}

			var storedToken = window.sessionStorage['token'];

			if(typeof storedToken !== 'undefined' && storedToken !== 'undefined' && storedToken !== null && storedToken !== 'null'){
				$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
					var currentToken = JSON.parse(storedToken);
					jqXHR.setRequestHeader("Authorization", "Bearer " + currentToken);
				});
			} else {
				utilities.cleanUpSession();
			}

			$(document).ajaxError(function(e, jqxhr, settings, exception) {
				if ( jqxhr.status == 0 || jqxhr.status == 200 || jqxhr.status == 400 || jqxhr.status == 404) {

				} else if (jqxhr.status == 403) {
					utilities.cleanUpSession();
					//alert("Invalid Session or connection timed out. Please login again");
					window.location = resources.get('oauth-login').get('href') + '?redirect_uri=' + utilities.getReferencePathWithHash();
				} else if (jqxhr.status == 401) {
					if (jqxhr.responseText.indexOf('invalid_token') > 0) {
						utilities.cleanUpSession();
						$.ajax(settings);
					}
				} else {
				    if($('#connection-failed').length === 0) {
						$('body').append(
							'<div id="connection-failed" data-role="dialog"> \
								<div data-role="header" data-theme="d"> \
									<h2>Error</h2> \
								</div> \
								<div data-role="content"> \
									<h3>The system cannot be reached.</h3>  \
									<p>If the server is unavailable you will be unable to use this application. <br />\
									You can close your browser and try again later or try to reconnect now.</p>  \
									<div> \
										<div><button id="retry-connection" data-mini="true" data-theme="b">Retry</button></div> \
									</div> \
								</div> \
							</div>'
						).trigger('create');
						$.mobile.changePage( "#connection-failed");
						$("#connection-failed").on('tap', '#retry-connection, a[title = "Close"]',function(){
							location.reload();
						});
					}
				}
			});

			if (hasTokenQueryParameter) {
				window.location = utilities.getReferencePathWithHash();
			}

		};
		utilities.parseTokenAndRegisterOauthHandler();

		utilities.registerLoadingSpinner = function() {
			$(document)
			.ajaxStart(function(event, xhr, settings) {
				$.mobile.loading('show');
			})
			.ajaxStop(function() {
				$.mobile.loading('hide');
			})
			.ajaxError(function() {
				$.mobile.loading('hide');
			});
		};

		utilities.create = function(page) {
			try {
				page.page("destroy");
			} catch (err) {
				// if page has not been initialized yet, destroy is not necessary
			}
			page.page();
		};

		utilities.eventAggregator = _.extend({}, Backbone.Events);
		utilities.eventAggregator.on("logout", function() {
			utilities.cleanUpSession();
		});

		return {
			getUtilities: function() {
				return utilities;
			}
		};
	}
);
