
module.exports = function( grunt ) {

grunt.loadTasks('test/grunt-tasks');

var testUrl = "http://127.0.0.1:8080/MobileHealthPlatformWeb/test/",
	dest = process.env.CATALINA_HOME + "/webapps/MobileHealthPlatformWeb/",
	config = {
		lint: {
			webapp: [
				"*.js"
			],
			test: [
				"test/appointments/*.js",
				"test/caring4WomenVets/*.js",
				"test/customdataview/*.js",
				"test/launchpad/*.js",
				"test/mbb/*.js",
				"test/mygoals/*.js",
				"test/patient-viewer/*.js",
				"test/reprohealth/*.js",
                "test/scheduling-calendar-view/*.js",
                "test/scheduling/*.js",
				"test/scheduling2/*.js",
				"test/scheduling-amd/*.js",
				"test/secure-messaging/*.js",
				"test/summaryofcare/*.js",
				"test/unit/*.js",
				"test/veteran-appointment-requests/*.js",
				"test/appointments-amd/*.js",
				"test/antibiogram/*.js"

			]
		},
		optimize: {
			"customdataview": "config",
			"launchpad": "config",
			"mbb": "config",
			//"mygoals": "config",
			"patient-viewer": "config",
			"scheduling-calendar-view": "config",
			"secure-messaging": "config",
			"summaryofcare": "config",
			"antibiogram": "config"
			//, "veteran-appointment-requests": "config"

		},
		deoptimize: {
			"customdataview": "config",
			"launchpad": "config",
			"mbb": "config",
			"mygoals": "config",
			"patient-viewer": "config",
			"scheduling-calendar-view": "config",
			"secure-messaging": "config",
			"summaryofcare": "config",
			"antibiogram": "config"
			//, "veteran-appointment-requests": "config"
		},
		requirejs: { // base task that optimize (multitask) will use
			compile: {
				options: {
					baseUrl: "",
					mainConfigFile: "",
					name: "",
					out: ""
				}
			}
		},

		deploy: {
			antibiogram: {
				src: "antibiogram/**",
				dest: dest
			},
			appointments: {
				src: "appointments/**",
				dest: dest
			},
			"appointments-amd": {
				src: "appointments-amd/**",
				dest: dest
			},
			common: {
				src: "common/**",
				dest: dest
			},
			caring4WomenVets: {
				src: "caring4WomenVets/**",
				dest: dest
			},
			css: {
				src: "css/**",
				dest: dest
			},
			customdataview: {
				src: "customdataview/**",
				dest: dest
			},
			fonts: {
				src: "fonts/**",
				dest: dest
			},
			html: {
				src: "html/**",
				dest: dest
			},
			img: {
				src: "img/**",
				dest: dest
			},
			js: {
				src: "js/**",
				dest: dest
			},
			launchpad: {
				src: "launchpad/**",
				dest: dest
			},
			mbb: {
				src: "mbb/**",
				dest: dest
			},
			mygoals: {
				src: "mygoals/**",
				dest: dest
			},
			reprohealth: {
				src: "reprohealth/**",
				dest: dest
			},
			roa: {
				src: "roa/**",
				dest: dest
			},
			scheduling: {
				src: "scheduling/**",
				dest: dest
			},
			scheduling2: {
				src: "scheduling2/**",
				dest: dest
			},
			"scheduling-amd": {
				src: "scheduling-amd/**",
				dest: dest
			},
			"scheduling-calendar-view": {
				src: "scheduling-calendar-view/**",
				dest: dest
			},
			"secure-messaging": {
				src: "secure-messaging/**",
				dest: dest
			},
			summaryofcare: {
				src: "summaryofcare/**",
				dest: dest
			},
			"patient-viewer": {
				src: "patient-viewer/**",
				dest: dest
			},
			"staff-user-disclaimer": {
				src: "staff-user-disclaimer/**",
				dest: dest
			},
			test: {
				src: "test/**",
				dest: dest
			},
			'veteran-appointment-requests': {
				src: "veteran-appointment-requests/**",
				dest: dest
			}
		},
		qunit: {
			appointments:  testUrl + "appointments/",
			caring4WomenVets:  testUrl + "caring4WomenVets/",
			customdataview:  testUrl + "customdataview/",
			launchpad:  testUrl + "launchpad/",
			mbb:  testUrl + "mbb/",
			mygoals:  testUrl + "mygoals/",
			reprohealth: testUrl + "reprohealth/",
			scheduling:  testUrl + "scheduling/",
			scheduling2:  testUrl + "scheduling2/",
			"scheduling-amd":  testUrl + "scheduling-amd/",
			"scheduling-calendar-view":  testUrl + "scheduling-calendar-view/",
			"secure-messaging":  testUrl + "secure-messaging/",
			summaryofcare:  testUrl + "summaryofcare/",
			"patient-viewer":  testUrl + "patient-viewer/",
			antibiogram:  testUrl + "antibiogram/",
			unit: testUrl + "unit/",
			"veteran-appointment-requests":  testUrl + "veteran-appointment-requests/",
			"appointments-amd": testUrl + "appointments-amd/"
		}
	};
	cheerio = require( "cheerio" );

grunt.initConfig( config );

	grunt.registerTask('set-revision', function() {
		grunt.task.requires('git-describe');

		grunt.event.once('git-describe', function (rev) {
			grunt.option('meta.revision', rev[0]);
		});
		grunt.task.run('git-describe');
	});

	grunt.registerTask('write-version', 'Tag the current build revision', function () {

		grunt.file.write('version.json', JSON.stringify({
			version: pkg['version'],
			revision: grunt.option('meta.revision'),
			date: grunt.template.today()
		}));
	});

	grunt.loadNpmTasks('grunt-contrib-requirejs');
	grunt.loadNpmTasks('grunt-git-describe');

grunt.registerMultiTask( "optimize", "Optimize web apps to production-ready state", function() {
	/* Optimize Javascript files using grunt-contrib-requirejs task */
	grunt.config.set('requirejs.compile.options.baseUrl', this.target + '/js');
	grunt.config.set('requirejs.compile.options.mainConfigFile', this.target + '/js/' + this.data + '.js');
	grunt.config.set('requirejs.compile.options.name', this.data);
	grunt.config.set('requirejs.compile.options.out', this.target + '/js/build/optimized.js');
	grunt.config.set('requirejs.compile.options.optimize', 'none');
	grunt.task.run('requirejs');

	/* Replace reference to requirejs in index.html to use new optimized file */
	var indexLocation = this.target + "/index.html",
		appIndexHtml = grunt.file.read( indexLocation ),
		$ = cheerio.load( appIndexHtml );
	$( "script[data-main='js/" + this.data + "']" ).attr( 'data-main', 'js/build/optimized' );
	grunt.file.write( indexLocation, $.html() );
});

grunt.registerMultiTask( "deoptimize", "Deoptimize web apps to development state", function() {
	/* Replace reference to requirejs in index.html to use new optimized file */
	var indexLocation = this.target + "/index.html",
		appIndexHtml = grunt.file.read( indexLocation ),
		$ = cheerio.load( appIndexHtml );
	$( "script[data-main='js/build/optimized']" ).attr( 'data-main', 'js/' + this.data );
	grunt.file.write( indexLocation, $.html() );
});


grunt.registerMultiTask( "deploy", "Copy files to destination folder", function() {
	var files = grunt.file.expandFiles( this.file.src ),
		target = this.file.dest;
	files.forEach(function( fileName ) {
		grunt.file.copy( fileName, target + fileName );
	});
	grunt.log.writeln( "Copied " + files.length + " files." );
});

grunt.registerTask( "test", "qunit:unit qunit:launchpad qunit:appointments  qunit:scheduling qunit:secure-messaging qunit:mbb qunit:summaryofcare qunit:caring4WomenVets qunit:mygoals" );
grunt.registerTask( "providerTest", "qunit:patient-viewer qunit:scheduling-calendar-view qunit:customdataview qunit:antibiogram" );
//grunt.registerTask( "default", "lint build deploy test" );
grunt.registerTask( "default", "lint deploy test" );
grunt.registerTask( "provider", "lint deploy providerTest" );
grunt.registerTask( "version", "git-describe set-revision write-version");

};
