define([
	'Global',
	'primaryHeaderView',
	'DateFormatJS',
	'QuestionResponses',
	'Text!../html/templates/panes/summary.html'
	],
	function(Global, PrimaryHeaderView, DateFormatJS, QuestionResponses, summaryTemplate) {
		var SummaryView = Backbone.View.extend({
			id: 'summary',
			tagName: 'div',
			className: 'alpha',

			initialize: function() {
				this.summaryTemplate  = _.template(summaryTemplate);
			},
			
			render: function() {
				var $container = this.options.viewContainer,
					summaryLink = this.options.summary,
					pdfLink = this.options.pdf,
					details = this.options.details,
					self = this;
				
				new QuestionResponses().fetch({
					url: summaryLink,
					success: function(response) {
						self.showSummary(response, details, pdfLink, $container);
						
					},
					error: function() {
						$('#pdf-btn').addClass('ui-disabled');
					}

				});
				$(window).scrollTop(0);
			},

			showSummary: function(response, details, pdfLink,  $container) {
				var details = response.getBaseline(details),
					displayNames = $(this.options.currPatientData.find('h3.ui-li-heading')).text().split(","),
					lastName = displayNames[0],
					firstName = displayNames[1],
					ssn = $(this.options.currPatientData.find('div.ui-block-a')).text(),
					last4ssn,
					dateOfBirth = $(this.options.currPatientData.find('div.ui-block-c')).text().split("(")[0];
				
				if (typeof(ssn) !== 'undefined') {
					last4ssn = ssn.substr(ssn.length - 4);
				} else {
					last4ssn = "";
				}
				$primaryContainer = $('#content-primary .scrollable');
				$('#pdf-btn').attr('href', pdfLink);
				
				if (response.length) {
					$.extend(
							details,
							{
								timestamp: this.timestamp(),
								pdf: pdfLink,
								name: lastName + " " + firstName, 
								patientLastName: lastName, 
								patientFirstName: firstName, 
								ssn: last4ssn,
								dob:dateOfBirth 
							}
						),	
					$container
						.empty()
						.append(this.summaryTemplate(details))
						.trigger('create')
						.addClass('summary-view');

                    $(":jqmData(role='header')", $primaryContainer)
                        .append(new PrimaryHeaderView()
                            .render({
                                title: 'MyStory Summary',
                                leftAction: { text: 'Views' },
                                rightAction: {
                                    id: 'pdf-btn',
                                    href: pdfLink,
                                    target: '_blank',
                                    text: 'PDF'
                                }
                            })
                        );
					
				} else {
					$(":jqmData(role='header')", $primaryContainer).append(new PrimaryHeaderView().render({title: 'MyStory Summary', leftAction: {text: 'Views' }}));
				
					this.renderNoInventory($container);
					
				}
				
			},
			
			renderNoInventory : function($container){
				$container
					.empty()
					.append(
						'<p>No data found.</p>'
					)
					.addClass('summary-view');
			},
			

			timestamp: function(){
				var time = new Date().format('mmm dd, yyyy');
				return time;
			},
			
		});

		return SummaryView;
	}
);