define([
	'Global',
	'Text!../html/templates/navbars/primaryHeader.html'
	],
	function(Global, primaryHeaderTemplate) {
		var PrimaryHeaderView = Backbone.View.extend({
			initialize: function() {
				this.template = _.template(primaryHeaderTemplate);
			},
			render: function(details) {
				var $container = $(this.el)
									.empty()
									.append(this.template(details));
				
				$('#content-primary').find(":jqmData(role='header')")
					.empty()
					.append($container)
					.trigger('create');
				
				return $container;
			},

			events: {
				"tap a.go-back" : "leftAction"
			},
			leftAction: function(e) {
				e.preventDefault();
				$('#patient-search-results .ui-btn-active').trigger('tap');
			}

		});
		return PrimaryHeaderView;
	}
);