define([
	'Global',
	'PV',
	'Resources',
	'Patients',
	'Patient',
	'primaryHeaderView',
	'secondaryHeaderView',
	'CustomData',
	'customDataView',
	'CustomDataColl',
	'summaryView',
	'Text!../html/templates/navbars/patientSearch.html',
	'Text!../html/templates/lists/listDivider.html',
	'Text!../html/templates/lists/listItem.html'
],
	function(Global, PV, resources, Patients, Patient, PrimaryHeaderView, SecondaryHeaderView, CustomData, CustomDataView, CustomDataColl, SummaryView, PatientSearchTemplate, listDividerTemplate, listItemTemplate) {
		var PatientSearchView = Backbone.View.extend({
				tagName: 'div',
				id: 'patient-search',
				dataLoading: false,
				endOfMessages: false,
				attributes: {},
				initialize: function(){
					this.template = _.template(PatientSearchTemplate);
					this.listDividerTemplate = _.template(listDividerTemplate);
					this.listItemTemplate = _.template(listItemTemplate);
				},
				render: function(){
					var that = this,
						$container = $(this.el),
						template = this.template,
						actions = {title: PV.getConstants().PATIENT_SEARCH_TITLE},
						$secondaryContainer = $('#content-secondary .scrollable'),
						$primaryContainer = $('#content-primary .scrollable');
						secondaryHeaderView = new SecondaryHeaderView();
						
					$container.empty().append(template());
					
					$(":jqmData(role='header')", $primaryContainer).append(new PrimaryHeaderView().render({title: 'Available Views'}));
					$primaryContainer.empty().append($container);
					$(":jqmData(role='header')", $secondaryContainer).append(new SecondaryHeaderView().render(actions));
					$secondaryContainer.empty().append($container);
					
					var scrollDirection,
					tempScrollTop, 
					currentScrollTop = 0;
				$('#content-secondary .scrollable').scroll(function(){
					if (!$('> ul', this).hasClass('no-scroll-event')) {
						currentScrollTop = $(this).scrollTop();

						if (tempScrollTop < currentScrollTop )
							scrollDirection = "down";
						else if (tempScrollTop > currentScrollTop )
							scrollDirection = "up";

						tempScrollTop = currentScrollTop;

						if (!that.endOfMessages && scrollDirection === "down") {
							var triggerPoint = 100; // 100px from the bottom
							
							if (!that.dataLoading && triggerPoint + this.clientHeight + this.scrollTop > this.scrollHeight) {
								that.dataLoading = true;
								that.next();									
							}
						}
					}
				});
				
				return this.$el;
			},
			events: {
				"tap .section-list-item": "viewCustomDataViews",
				"keypress input[name=patient-search]": "searchOnEnter"
					
			},
			searchOnEnter: function(e) {
				if (e.keyCode != 13) return; 
				this.search(e);
			},
			search: function(e){
				var that = this,
					$ul = $('#patient-search-results').empty(),
			
				    getSelfLink = function(object) {
						var linksArr = object.attributes.link;
						if (typeof linksArr !== 'undefined') {
							for (var i=0; i<linksArr.length; i++) {
								if(linksArr[i].title ==="custom-data-view") return linksArr[i].href;
							}
						}
						return null;
					};					
				
					this.searchedUrl = resources.get('patients').get('href') + "?searchstring=" + $('input[name=patient-search]').val();
				
				Patients.instance().fetch({
					url: this.searchedUrl,
					success: function(collection) {
						$ul.append(that.listDividerTemplate(collection));
						$(collection.models).each(function() {
							$ul.append(that.listItemTemplate($.extend(this.toJSON(), {selflink: getSelfLink(this) })));
						});
						
						$ul.listview('refresh');
						
						if (!collection.nextPage) {
							that.endOfMessages = true;
						} else {
							that.endOfMessages = false;
						}
						$('#content-primary .scrollable').empty();
						$('#pdf-btn').addClass('ui-disabled');
					},
					error: function() {
						that.endOfMessages = true;
					}
				});
			},

			next: function(e){
				if (typeof this.searchedUrl !== 'undefined' && this.searchedUrl && typeof Patients.instance().nextPage !== 'undefined' && Patients.instance().nextPage) {
					var that = this,
						$ul = $('#patient-search-results'),
						
					    getSelfLink = function(object) {
							var linksArr = object.attributes.link;
							if (typeof linksArr !== 'undefined') {
								for (var i=0; i<linksArr.length; i++) {
									if(linksArr[i].title ==="custom-data-view") return linksArr[i].href;
								}
							}
							return null;
						};	
					
					Patients.instance().fetch({
						url: this.searchedUrl + '&page=' + Patients.instance().nextPage,
						success: function(collection) {
							$('#displayed-result-count').html('Displaying ' + Patients.instance().numberOfDisplayedResults+ ' results');
							
							$(collection.models).each(function() {
								$ul.append(that.listItemTemplate($.extend(this.toJSON(), {selflink: getSelfLink(this) })));
							});
							
							$ul.listview('refresh');

							if (!collection.nextPage) {
								that.endOfMessages = true;
							}
							
							that.dataLoading = false;
						},
						error: function() {
							that.dataLoading = false;
						}
					});
				}
			},
			viewCustomDataViews: function(e) {
				var currPatientData = $(e.currentTarget),
					selflink = currPatientData.data('selflink'),
					itemParent = currPatientData.parents('li');
				
				itemParent
					.parents('#patient-search-results')
						.find('.ui-btn-active').removeClass('ui-btn-active')
						.end()
					.end()
					.addClass('ui-btn-active');
				currPatientData.addClass('ui-btn-active');
				
				customViews = new CustomDataColl();
				customViews.fetch({
					url: selflink,
					success: function(response) {
						Global.getUtilities().flattenLinks(response); 
						new CustomDataView({
							model : response,
							currPatientData : currPatientData,
							viewContainer : $('.content-primary')
						}).render();
						Global.getUtilities().slidePrimary();
						
					},
					error: function() {
						alert('Error fetching patient');
					}
				});
				$('#pdf-btn').addClass('ui-disabled');
			}
		});
	
	return PatientSearchView;
	}
);