define([
	'Global',
	'primaryHeaderView',
	'summaryView',
	'Questions',
	'Text!../html/templates/panes/availableApps.html'
	],
	function(Global, PrimaryHeaderView, SummaryView, Questions, appsTemplate) {

		var CustomDataView = Backbone.View.extend({
			
			initialize : function() {
				this.customViewTemplate = _.template(appsTemplate);
			},

			render : function() {
				var $container = $('#content-primary .scrollable'),//this.options.viewContainer,
					customViews = this.options.model,
					$primaryContainer = $('#content-primary .scrollable');

				if (customViews !== null) {
					$container
						.removeAttr('style')
						.empty()
						.append(
                            this.$el
                                .append(this.customViewTemplate({ "customViewList": customViews.toJSON() }) )
                        )
						.trigger('create');
				}
				$(":jqmData(role='header')", $primaryContainer).append(new PrimaryHeaderView().render({title: 'Available Views'}));
				
				return $primaryContainer;
			},
			
			events: {
				"tap a": "selectAppNameEvent"
			},
			
			selectAppNameEvent:function(e) {
				e.preventDefault();
				var collection = this.model.toJSON(),
					app_name = collection[0].customViewName,
					summaryLink = collection[0].latest.href,
					pdfLink = collection[0].report.href;

				switch(app_name){
				case "MyStory":
					new SummaryView({
						summary : summaryLink,
						pdf : pdfLink,
						details : new Questions().details,
						currPatientData : this.options.currPatientData,
						viewContainer : $('#content-primary .scrollable')
					}).render();
					$('.content-primary .scrollable').height(
						$('[data-role="content"]').height()
						- $('.ui-header').height()
						- $('#footer').height()
					);	
					break;
				default:
					break;
				}
			}
			
		});

			
		return CustomDataView;
	}
);