define([
    //Paths from config.js, each passed into the following anonymous function
    'Global',
    'mainView',
    'PatientSearchView',
    'summaryView',
    'User'
], function (Global, MainView, PatientSearchView, SummaryView, user) {

    // http://documentcloud.github.com/backbone/#Router
    'use strict';
    var AppRouter = Backbone.Router.extend({
            initialize: function (options) {
                $.mobile.autoInitializePage = false;
                Global.getUtilities().globalInit({user: user, provider: true});
            },
            routes: {
                'summary': 'showSummary',
                // Default
                '*actions': 'defaultAction'
            },

            //Pages
            showPatientSearch: function (e) {
                this.openPage(new PatientSearchView());
            },
            showSummary: function (e) {
                this.openPage(new SummaryView());
            },
            defaultAction: function () {
                this.showPatientSearch();
            },
            //route
            openPage: function (page) {
                var pageType = $(page.el).eq(0).attr('data-role'),
                    primaryView = $('#content-primary');
                this.buildMain.call(this, page);
                this.activateFooter(Backbone.history.fragment);

                if (pageType === 'dialog') {
                    page.render();
                    $.mobile.changePage("#" + page.id, {transition: 'pop'});
                } else {
                    $('#main').animationComplete(function () {
                        page.render().trigger('create');
                        if (primaryView.hasClass("closed")) {
                            Global.getUtilities().slidePrimary();
                        }
                    });
                    $.mobile.changePage("#main", {allowSamePageTransition: true});
                }

                //Size scrollables
                setTimeout(function () {
                    $(window).triggerHandler('resize');
                }, 100);
            },

            activateFooter: function (page) {
                $('#footer a').removeClass('ui-btn-active');
                $('#footer a[href="#' + page + '"]').addClass('ui-btn-active');
            },

            buildMain: (_.once(function (page) {
                $('body').append(new MainView().render());
            }))
        }),
        appRouter = new AppRouter(),
        eventAggregator = Global.getUtilities().eventAggregator;

    eventAggregator.on("home", function () {
        appRouter.navigate('', {trigger: true});
    });

    eventAggregator.on("summary", function () {
        appRouter.navigate('#summary', {trigger: true});
    });

    eventAggregator.on("patient-search", function () {
        appRouter.navigate('#patient-search', {trigger: true});
    });

    Backbone.history.start();
});